import time as TIM
# NC import random as RND
# NC import numpy as NUM
#
import tkinter as TKI
# NC from tkinter import ttk as TTK
#
import Define as DEF
import Task as TSK
import GCodeConverter as GCV
import GCodeSimulator as GCS
import FrameApplication as FRA
#
#---------------------------------------------------------
# Field
#---------------------------------------------------------
global TaskCreatePlotData, TaskDisplayPlotdata, EventDisplayReady
global GCodeList, GCodeLines
# #
# #---------------------------------------------------------
# # Callback - Task - Refresh
# #---------------------------------------------------------
def OnTaskDisplayPlotdataStart(task):
    global TaskCreatePlotData, TaskDisplayPlotdata, EventDisplayReady
    global GCodeList, GCodeLines
    # debug print('OnTaskDisplayPlotdataStart[{0}]: begin'.format(task.ID))
    EventDisplayReady.Clear()
    # debug print('OnTaskDisplayPlotdataStart[{0}]: end'.format(task.ID))
    return
def OnTaskDisplayPlotdataAbort(task):
    # debug print('OnTaskDisplayPlotdataAbort[{0}]: begin'.format(task.ID))
    # debug print('OnTaskDisplayPlotdataAbort[{0}]: end'.format(task.ID))
    return
#
def OnTaskDisplayPlotdataExecute(task):
    global TaskCreatePlotData, TaskDisplayPlotdata, EventDisplayReady
    global GCodeList, GCodeLines
    # debug print('OnTaskDisplayPlotdataExecute[{0}]: begin'.format(task.ID))
    #
    try:
        T0 = TIM.time()
        T1 = T0
        IL = 0
        IH = max(0, len(GCodeSimulator.GetVX1()) - 1)
        IA = 0
        Loop = True
        while (Loop):
            if ((T1 + DEF.TIME_REFRESH) < TIM.time()):
                T1 = T1 + DEF.TIME_REFRESH
                IA = min(IH, 1 + IA)
                XL = GCodeSimulator.GetXL()
                XH = GCodeSimulator.GetXH()
                DXT = (XH - XL) / 10.0
                XL -= DXT
                XH += DXT
                YL = GCodeSimulator.GetYL()
                YH = GCodeSimulator.GetYH()
                DYT = (YH - YL) / 10.0
                YL -= DYT
                YH += DYT
                FrameApplication.tbsPlot2D.Refresh(GCodeSimulator.GetVX0(),
                                                   GCodeSimulator.GetVY0(),
                                                   GCodeSimulator.GetVX1(),
                                                   GCodeSimulator.GetVY1(),
                                                   IL, IA, IH,
                                                   XL, XH, YL, YH)
                # TIM.sleep(0.001)
            else:
                # debug print('...')
                TIM.sleep(DEF.TIME_REFRESH / 10.0)
            #
            if (GCodeSimulator.GetTP() <= (T1 - T0)):
                Loop = False
            #
        # debug print('...SET...')
        EventDisplayReady.Set()
        # debug print('!!!!!!!! OnTaskDisplayPlotdataExecute[{0}]: end'.format(task.ID))
    except:
        print('Error: Executing Display')
    return False
#
#---------------------------------------------------------
# Callback - Task - Action
#---------------------------------------------------------
def OnTaskCreatePlotdataStart(task):
    global TaskCreatePlotData, TaskDisplayPlotdata, EventDisplayReady
    global GCodeList, GCodeLines
    return
def OnTaskCreatePlotdataAbort(task):
    global TaskCreatePlotData, TaskDisplayPlotdata, EventDisplayReady
    global GCodeList, GCodeLines
    if (TaskDisplayPlotdata.IsBusy()):
        TaskDisplayPlotdata.Abort()
    return
def OnTaskCreatePlotdataExecute(task):
    global TaskCreatePlotData, TaskDisplayPlotdata, EventDisplayReady
    global GCodeList, GCodeLines
    FileEntry = 'AR.gcode'
    print('>>> Read GCodeList from File[{0}]:'.format(FileEntry))
    [GCodeList, GCodeLines] = GCodeConverter.ReadFromFile(FileEntry)
    print(GCodeList.Text())
    print('>>> ExecuteGCodelist[{0}]: begin'.format(len(GCodeList)))
    for GCode in GCodeList:
        GCodeSimulator.ExecuteGCode(GCode)
        TaskDisplayPlotdata.Start()
        EventDisplayReady.Wait()
    print('>>> ExecuteGCodelist[{0}]: end'.format(len(GCodeList)))
    return False
#---------------------------------------------------------
# Main - Callback
#---------------------------------------------------------
def OnFrameApplicationDelete():
    global TaskCreatePlotData, TaskDisplayPlotdata, EventDisplayReady
    global GCodeList, GCodeLines
    if (TaskCreatePlotdata.IsBusy()):
        TaskCreatePlotdata.Abort()
    return
#---------------------------------------------------------
# Main
#---------------------------------------------------------
if ('__main__' == __name__):
    print('*** RealTimePlot2D: begin')
    #
    FrameApplication = FRA.CFrameApplication(TKI.Tk(), OnFrameApplicationDelete)
    #
    GCodeConverter = GCV.CGCodeConverter()
    GCodeSimulator = GCS.CGCodeSimulator()
    #
    EventDisplayReady = TSK.CEvent()
    TaskDisplayPlotdata = TSK.CTask('TaskDisplayPlotdataData',
                                    OnTaskDisplayPlotdataStart,
                                    OnTaskDisplayPlotdataAbort,
                                    OnTaskDisplayPlotdataExecute)
    TaskCreatePlotdata = TSK.CTask('TaskCreatePlotdata',
                                   OnTaskCreatePlotdataStart,
                                   OnTaskCreatePlotdataAbort,
                                   OnTaskCreatePlotdataExecute)
    TaskCreatePlotdata.Start()
    #
    FrameApplication.Execute()
    #
    print('*** RealTimePlot2D: end')
    #
    #
#
#
###################################################################
#
