#
import time as TIM
#
import Define as DEF
import Task as TSK
#
import GCodeConverter as GCV
import GCodeSimulator as GCS
#
class CGCodeExecutor():
    #
    def __init__(self):
        self.EventDisplayReady = TSK.CEvent()
        self.TaskDisplayPlotdata = TSK.CTask('TaskDisplayPlotdataData',
                                             self.OnTaskDisplayPlotdataStart,
                                             self.OnTaskDisplayPlotdataAbort,
                                             self.OnTaskDisplayPlotdataExecute)
        self.TaskCreatePlotdata = TSK.CTask('TaskCreatePlotdata',
                                            self.OnTaskCreatePlotdataStart,
                                            self.OnTaskCreatePlotdataAbort,
                                            self.OnTaskCreatePlotdataExecute)
        return
    #
    #---------------------------------------------------------
    # Callback - Task - Refresh
    #---------------------------------------------------------
    def OnTaskDisplayPlotdataStart(self, task):
        # debug print('OnTaskDisplayPlotdataStart[{0}]: begin'.format(task.ID))
        self.EventDisplayReady.Clear()
        # debug print('OnTaskDisplayPlotdataStart[{0}]: end'.format(task.ID))
        return
    def OnTaskDisplayPlotdataAbort(self, task):
        # debug print('OnTaskDisplayPlotdataAbort[{0}]: begin'.format(task.ID))
        # debug print('OnTaskDisplayPlotdataAbort[{0}]: end'.format(task.ID))
        return
    #
    def OnTaskDisplayPlotdataExecute(self, task):
        # debug print('OnTaskDisplayPlotdataExecute[{0}]: begin'.format(task.ID))
        #
        try:
            T0 = TIM.time()
            T1 = T0
            IL = 0
            IH = max(0, len(self.GCodeSimulator.GetVX1()) - 1)
            IA = 0
            Loop = True
            while (Loop):
                if ((T1 + DEF.TIME_REFRESH) < TIM.time()):
                    T1 = T1 + DEF.TIME_REFRESH
                    IA = min(IH, 1 + IA)
                    XL = self.GCodeSimulator.GetXL()
                    XH = self.GCodeSimulator.GetXH()
                    DXT = (XH - XL) / 10.0
                    XL -= DXT
                    XH += DXT
                    YL = self.GCodeSimulator.GetYL()
                    YH = self.GCodeSimulator.GetYH()
                    DYT = (YH - YL) / 10.0
                    YL -= DYT
                    YH += DYT
                    self.FramePlot2D.Refresh(self.GCodeSimulator.GetVX0(),
                                             self.GCodeSimulator.GetVY0(),
                                             self.GCodeSimulator.GetVX1(),
                                             self.GCodeSimulator.GetVY1(),
                                             IL, IA, IH,
                                             XL, XH, YL, YH)
                    # TIM.sleep(0.001)
                else:
                    # debug print('...')
                    TIM.sleep(DEF.TIME_REFRESH / 10.0)
                #
                if (self.GCodeSimulator.GetTP() <= (T1 - T0)):
                    Loop = False
                #
            # debug print('...SET...')
            self.EventDisplayReady.Set()
            # debug print('!!!!!!!! OnTaskDisplayPlotdataExecute[{0}]: end'.format(task.ID))
        except:
            print('Error: Executing Display')
        return False
    #---------------------------------------------------------
    # Callback - Task - Action
    #---------------------------------------------------------
    def OnTaskCreatePlotdataStart(self, task):
        return
    def OnTaskCreatePlotdataAbort(self, task):
        if (self.TaskDisplayPlotdata.IsBusy()):
            self.TaskDisplayPlotdata.Abort()
        return
    def OnTaskCreatePlotdataExecute(self, task):
        print('>>> Read GCodeList from File[{0}]:'.format(self.FileEntry))
        [GCodeList, GCodeLines] = self.GCodeConverter.ReadFromFile(self.FileEntry)
        print(GCodeList.Text())
        print('>>> ExecuteGCodelist[{0}]: begin'.format(len(GCodeList)))
        for GCode in GCodeList:
            self.GCodeSimulator.ExecuteGCode(GCode)
            self.TaskDisplayPlotdata.Start()
            self.EventDisplayReady.Wait()
        print('>>> ExecuteGCodelist[{0}]: end'.format(len(GCodeList)))
        return False
    #
    #---------------------------------------------------------
    # Handler
    #---------------------------------------------------------
    def Init(self, frameplot2d):
        self.GCodeSimulator = GCS.CGCodeSimulator()
        self.GCodeConverter = GCV.CGCodeConverter()
        self.FramePlot2D = frameplot2d
    #
    def Start(self, fileentry):
        self.FileEntry = fileentry
        self.TaskCreatePlotdata.Start()
        return
    #
    def Abort(self):
        if (self.TaskCreatePlotdata.IsBusy()):
            self.TaskCreatePlotdata.Abort()
        return
    #
    #
#
#
