import time as TIM
import numpy as NUM
# NC from itertools import count
import matplotlib as MPL
import matplotlib.pyplot as PLT
from matplotlib.animation import FuncAnimation
import tkinter as TKI
#
import Define as DEF
import Task as TSK
import FrameMain as FMN
#
global VX, VY, VZ, Direction, ticks, MainWindow
VX = []
VY = []
VZ = []
Rmin = 1.0
Rmax = 5.0
XM = 5.0
YM = 5.0
Modulo = 1024
Direction = True
ticks = 0
#
def OnStart(task):
    global MainWindow
    MainWindow.FramePlot.SetTimePeriodic(DEF.TIMEPERIOD_PLOT_MS)
    return
def OnAbort(task):
    global MainWindow
    MainWindow.FramePlot.SetTimePeriodic(DEF.TIMEPERIOD_IDLE_MS)
    return
def OnExecute(task):
    global MainWindow
    global VX, VY, VZ, Direction, ticks
    ticks += 1
    Ticks = ticks % Modulo
    A = 20 * NUM.pi * Ticks / Modulo
    R = Rmin + Ticks / Modulo * (Rmax - Rmin)
    X = DEF.XM + R * NUM.cos(A)
    Y = DEF.YM + R * NUM.sin(A)
    Z = DEF.LIMIT_Z_LOW + (DEF.LIMIT_Z_HIGH - DEF.LIMIT_Z_LOW) * Ticks / Modulo
    if (0 == Ticks):
        VX = []
        VY = []
        VZ = []
    VX.append(X)
    VY.append(Y)
    VZ.append(Z)
    if (0 == Ticks):
        Direction = not(Direction)
    if (Direction):
        Elevation = Ticks / Modulo * 85.0
        Azimuth = Ticks / Modulo * 90.0
    else:
        Elevation = (Modulo - Ticks) / Modulo * 85.0
        Azimuth = (Modulo - Ticks) / Modulo * 90.0
    MainWindow.FramePlot.SetVX(VX)
    MainWindow.FramePlot.SetVY(VY)
    MainWindow.FramePlot.SetVZ(VZ)
    MainWindow.FramePlot.SetXL(DEF.LIMIT_X_LOW)
    MainWindow.FramePlot.SetXH(DEF.LIMIT_X_HIGH)
    MainWindow.FramePlot.SetYL(DEF.LIMIT_Y_LOW)
    MainWindow.FramePlot.SetYH(DEF.LIMIT_Y_HIGH)
    MainWindow.FramePlot.SetZL(DEF.LIMIT_Z_LOW)
    MainWindow.FramePlot.SetZH(DEF.LIMIT_Z_HIGH)
    MainWindow.FramePlot.SetElevation(Elevation)
    MainWindow.FramePlot.SetAzimuth(Azimuth)
    TIM.sleep(0.001)
    MainWindow.FramePlot.TriggerPlot()
    return task.IsBusy()
#
#----------------------------------------------------------------------
#   Main
#----------------------------------------------------------------------
if ('__main__' == __name__):
    print('*** RealTimePlot3D: begin')
    #
    MainWindow = FMN.CFrameMain(TKI.Tk())

    T = TSK.CTask('T', OnStart, OnAbort, OnExecute)
    T.Start()

    MainWindow.Execute();
    #
    if T.IsBusy():
        T.Abort()
    #
    print('*** RealTimePlot3D: end')
    #
    #
#
#
#####################################################################
