import time as TIM
import numpy as NUM
import tkinter as TKI
#
import Define as DEF
import Task as TSK
import FrameApplication as FRA
#
#---------------------------------------------------------
# Field
#---------------------------------------------------------
global VX, VY, VZ, Direction, GlobalTicks, FrameApplication
VX = []
VY = []
VZ = []
Rmin = 1.0
Rmax = 5.0
XM = 5.0
YM = 5.0
Modulo = 1024
Direction = True
GlobalTicks = 0
#
#---------------------------------------------------------
# Callback - Task - Refresh
#---------------------------------------------------------
def OnTaskPlotStart(task):
    global FrameApplication
    FrameApplication.FramePlot.SetTimePeriodic(DEF.TIMEPERIOD_PLOT_MS)
    return
def OnTaskPlotAbort(task):
    global FrameApplication
    FrameApplication.FramePlot.SetTimePeriodic(DEF.TIMEPERIOD_IDLE_MS)
    return
def OnTaskPlotExecute(task):
    global FrameApplication
    global VX, VY, VZ, Direction, GlobalTicks
    GlobalTicks += 1
    Ticks = GlobalTicks % Modulo
    A = 20 * NUM.pi * Ticks / Modulo
    R = Rmin + Ticks / Modulo * (Rmax - Rmin)
    X = DEF.XM + R * NUM.cos(A)
    Y = DEF.YM + R * NUM.sin(A)
    Z = DEF.LIMIT_Z_LOW + (DEF.LIMIT_Z_HIGH - DEF.LIMIT_Z_LOW) * Ticks / Modulo
    if (0 == Ticks):
        VX = []
        VY = []
        VZ = []
    VX.append(X)
    VY.append(Y)
    VZ.append(Z)
    if (0 == Ticks):
        Direction = not(Direction)
    if (Direction):
        Elevation = Ticks / Modulo * 85.0
        Azimuth = Ticks / Modulo * 90.0
    else:
        Elevation = (Modulo - Ticks) / Modulo * 85.0
        Azimuth = (Modulo - Ticks) / Modulo * 90.0
    FrameApplication.FramePlot.SetVX(VX)
    FrameApplication.FramePlot.SetVY(VY)
    FrameApplication.FramePlot.SetVZ(VZ)
    FrameApplication.FramePlot.SetXL(DEF.LIMIT_X_LOW)
    FrameApplication.FramePlot.SetXH(DEF.LIMIT_X_HIGH)
    FrameApplication.FramePlot.SetYL(DEF.LIMIT_Y_LOW)
    FrameApplication.FramePlot.SetYH(DEF.LIMIT_Y_HIGH)
    FrameApplication.FramePlot.SetZL(DEF.LIMIT_Z_LOW)
    FrameApplication.FramePlot.SetZH(DEF.LIMIT_Z_HIGH)
    FrameApplication.FramePlot.SetElevation(Elevation)
    FrameApplication.FramePlot.SetAzimuth(Azimuth)
    TIM.sleep(0.001)
    FrameApplication.FramePlot.TriggerPlot()
    return task.IsBusy()
#---------------------------------------------------------
# Main - Callback
#---------------------------------------------------------
def OnFrameApplicationDelete():
    # debug print('OnFrameApplicationDelete')
    if (TaskPlot.IsBusy()):
        TaskPlot.Abort()
    return
#----------------------------------------------------------------------
#   Main
#----------------------------------------------------------------------
if ('__main__' == __name__):
    print('*** RealTimePlot3D: begin')
    #
    FrameApplication = FRA.CFrameApplication(TKI.Tk(), OnFrameApplicationDelete)

    TaskPlot = TSK.CTask('Task', OnTaskPlotStart,
                         OnTaskPlotAbort, OnTaskPlotExecute)
    TaskPlot.Start()

    FrameApplication.Execute();
    #
    print('*** RealTimePlot3D: end')
    #
    #
#
#
#####################################################################
