#
#----------------------------------------------------------------------
#   FrameApplication
#----------------------------------------------------------------------
import tkinter as TKI
#
import Define as DEF
import FramePlot as FPL
#
#----------------------------------------------------------------------
class CFrameApplication(TKI.Frame):
    def __init__(self, frameparent, onframeapplicationdelete):
        TKI.Frame.__init__(self, frameparent)
        self.FrameParent = frameparent
        self.FrameParent.protocol('WM_DELETE_WINDOW', self.OnWMDeleteWindow)
        self.OnFrameApplicationDelete = onframeapplicationdelete
        #
        #--------------------------------------------------------
        # Common
        #--------------------------------------------------------
        # self.TK.geometry("800x800+2033+33")
        #self.TK.geometry("1800x1000+33+33")
        self.FrameParent.geometry('804x626+2022+22')
        self.FrameParent.title(DEF.NAME_APPLICATION)
        #
        self.FrameParent.rowconfigure(index=0, weight=6)
        self.FrameParent.columnconfigure(index=0, weight=6)
        #------------------------------------------------------------
        # Plot
        self.FramePlot = FPL.CFramePlot(self.FrameParent)
        self.FramePlot.grid(row=0, column=0, sticky='nesw')
        #------------------------------------------------------------
        return
    #---------------------------------------------------------------------
    # CWindowMain - Callback
    #---------------------------------------------------------------------
    def OnWMDeleteWindow(self):
        # debug print('OnWMWindowDelete')
        # self.WriteInitdata(DEF.NAME_INITFILE)
        if (None != self.OnFrameApplicationDelete):
            self.OnFrameApplicationDelete()
        self.FrameParent.destroy()
        return
    #---------------------------------------------------------------------
    # CWindowMain - Handler
    #---------------------------------------------------------------------
    def Execute(self):
        self.FrameParent.mainloop()
    #
    #
#
#
