import time as TIM
import numpy as NUM
import tkinter as TKI
#
import Define as DEF
import Task as TSK
import FrameApplication as FRA
#
#---------------------------------------------------------
# Field
#---------------------------------------------------------
global VX, VY, VZ, Direction, GlobalTicks, FrameApplication
VX = []
VY = []
VZ = []
Rmin = 1.0
Rmax = 5.0
XM = 5.0
YM = 5.0
Modulo = 1024
Direction = True
GlobalTicks = 0
#
#---------------------------------------------------------
# Callback - Task - Refresh
#---------------------------------------------------------
def OnTaskPlotStart(task):
    global FrameApplication
    FrameApplication.FramePlot3D.SetTimePeriodic(DEF.TIMEPERIOD_PLOT_MS)
    return
def OnTaskPlotAbort(task):
    global FrameApplication
    FrameApplication.FramePlot3D.SetTimePeriodic(DEF.TIMEPERIOD_IDLE_MS)
    return
def OnTaskPlotExecute(task):
    global FrameApplication
    global VX, VY, VZ, Direction, GlobalTicks
    GlobalTicks += 1
    Ticks = GlobalTicks % Modulo
    A = 20 * NUM.pi * Ticks / Modulo
    R = Rmin + Ticks / Modulo * (Rmax - Rmin)
    X = DEF.XM + R * NUM.cos(A)
    Y = DEF.YM + R * NUM.sin(A)
    Z = DEF.LIMIT_Z_LOW + (DEF.LIMIT_Z_HIGH - DEF.LIMIT_Z_LOW) * Ticks / Modulo
    if (0 == Ticks):
        VX = []
        VY = []
        VZ = []
    VX.append(X)
    VY.append(Y)
    VZ.append(Z)
    if (0 == Ticks):
        Direction = not(Direction)
    if (Direction):
        Elevation = Ticks / Modulo * 85.0
        Azimuth = Ticks / Modulo * 90.0
    else:
        Elevation = (Modulo - Ticks) / Modulo * 85.0
        Azimuth = (Modulo - Ticks) / Modulo * 90.0
    FrameApplication.FramePlot3D.SetVX(VX)
    FrameApplication.FramePlot3D.SetVY(VY)
    FrameApplication.FramePlot3D.SetVZ(VZ)
    FrameApplication.FramePlot3D.SetXL(DEF.LIMIT_X_LOW)
    FrameApplication.FramePlot3D.SetXH(DEF.LIMIT_X_HIGH)
    FrameApplication.FramePlot3D.SetYL(DEF.LIMIT_Y_LOW)
    FrameApplication.FramePlot3D.SetYH(DEF.LIMIT_Y_HIGH)
    FrameApplication.FramePlot3D.SetZL(DEF.LIMIT_Z_LOW)
    FrameApplication.FramePlot3D.SetZH(DEF.LIMIT_Z_HIGH)
    FrameApplication.FramePlot3D.SetElevation(Elevation)
    FrameApplication.FramePlot3D.SetAzimuth(Azimuth)
    #
    FrameApplication.FramePlot3D.Refresh()
    TIM.sleep(0.000001)
    return task.IsBusy()
#---------------------------------------------------------
# Main - Callback
#---------------------------------------------------------
def OnFrameApplicationDelete():
    # debug print('OnFrameApplicationDelete')
    if (TaskPlot.IsBusy()):
        TaskPlot.Abort()
    return
#----------------------------------------------------------------------
#   Main
#----------------------------------------------------------------------
if ('__main__' == __name__):
    print('*** RealTimePlot3D: begin')
    #
    FrameApplication = FRA.CFrameApplication(TKI.Tk(), OnFrameApplicationDelete)

    TaskPlot = TSK.CTask('Task', OnTaskPlotStart,
                         OnTaskPlotAbort, OnTaskPlotExecute)
    TaskPlot.Start()

    FrameApplication.Execute();
    #
    print('*** RealTimePlot3D: end')
    #
    #
#
#
#####################################################################
