#import time as TIM
import numpy as NUM
#import tkinter as TKI
#
import Define as DEF
import Task as TSK
import FrameApplication as FRA
#
#---------------------------------------------------------
# Field
#---------------------------------------------------------
global VX, VY, VZ, Direction, GlobalTicks, FrameApplication
VX = []
VY = []
VZ = []
Rmin = 1.0
Rmax = 5.0
XM = 5.0
YM = 5.0
Modulo = 256
Direction = True
GlobalTicks = 0
#
#---------------------------------------------------------
# Callback - Task - Refresh
#---------------------------------------------------------
def OnTaskPlotStart(task):
    global FrameApplication
    FrameApplication.FramePlot3D.SetXLH(DEF.LIMIT_X_LOW, DEF.LIMIT_X_HIGH)
    FrameApplication.FramePlot3D.SetYLH(DEF.LIMIT_Y_LOW, DEF.LIMIT_Y_HIGH)
    FrameApplication.FramePlot3D.SetZLH(DEF.LIMIT_Z_LOW, DEF.LIMIT_Z_HIGH)
    FrameApplication.FramePlot3D.SetLineColor('#5555ff')
    FrameApplication.FramePlot3D.SetLineWidth(1.0)
    FrameApplication.FramePlot3D.SetLineStyle('solid')
    FrameApplication.FramePlot3D.SetLineMarker('.')
    FrameApplication.FramePlot3D.Plot()
    return
def OnTaskPlotAbort(task):
    global FrameApplication
    return
def OnTaskPlotExecute(task):
    global FrameApplication
    global VX, VY, VZ, Direction, GlobalTicks
    GlobalTicks += 1
    Ticks = GlobalTicks % Modulo
    A = 20 * NUM.pi * Ticks / Modulo
    R = Rmin + Ticks / Modulo * (Rmax - Rmin)
    X = DEF.XM + R * NUM.cos(A)
    Y = DEF.YM + R * NUM.sin(A)
    Z = DEF.LIMIT_Z_LOW + (DEF.LIMIT_Z_HIGH - DEF.LIMIT_Z_LOW) * Ticks / Modulo
    if (0 == Ticks):
        VX = []
        VY = []
        VZ = []
        Direction = not(Direction)
    if (Direction):
        Elevation = Ticks / Modulo * 85.0
        Azimuth = Ticks / Modulo * 90.0
    else:
        Elevation = (Modulo - Ticks) / Modulo * 85.0
        Azimuth = (Modulo - Ticks) / Modulo * 90.0
    VX.append(X)
    VY.append(Y)
    VZ.append(Z)
    #
    FrameApplication.FramePlot3D.SetElevation(Elevation)
    FrameApplication.FramePlot3D.SetAzimuth(Azimuth)
    FrameApplication.FramePlot3D.SetVXYZ(VX, VY, VZ)
    FrameApplication.FramePlot3D.Plot()
    # NC TIM.sleep(0.00001)
    return task.IsBusy()
#---------------------------------------------------------
# Main - Callback
#---------------------------------------------------------
def OnFrameApplicationDelete():
    if (TaskPlot.IsBusy()):
        TaskPlot.Abort()
    return
#----------------------------------------------------------------------
#   Main
#----------------------------------------------------------------------
if ('__main__' == __name__):
    print('*** RealTimePlot3D: begin')
    #
    FrameApplication = FRA.CFrameApplication(OnFrameApplicationDelete)

    TaskPlot = TSK.CTask('Task', OnTaskPlotStart,
                         OnTaskPlotAbort, OnTaskPlotExecute)
    TaskPlot.Start()
    #
    FrameApplication.Execute();
    #
    print('*** RealTimePlot3D: end')
    #
    #
#
#
#####################################################################
