#
#----------------------------------------------------------------------
#   FrameApplication
#----------------------------------------------------------------------
import tkinter as TKI
#
import Define as DEF
import FramePlot3D as FP3D
#
#----------------------------------------------------------------------
class CFrameApplication(TKI.Frame):
    def __init__(self, onframeapplicationdelete):
        self.FrameMain = TKI.Tk()
        TKI.Frame.__init__(self, self.FrameMain)
        self.FrameMain.protocol('WM_DELETE_WINDOW', self.OnWMDeleteWindow)
        self.OnFrameApplicationDelete = onframeapplicationdelete
        #--------------------------------------------------------
        # Common
        #--------------------------------------------------------
        # self.TK.geometry("800x800+2033+33")
        #self.TK.geometry("1800x1000+33+33")
        self.FrameMain.geometry('804x626+22+22')
        #self.FrameMain.geometry('804x626+2022+22')
        self.FrameMain.title(DEF.NAME_APPLICATION)
        #
        self.FrameMain.rowconfigure(index=0, weight=6)
        self.FrameMain.columnconfigure(index=0, weight=6)
        #
        self.FrameMain.config(bg='red')
        #------------------------------------------------------------
        # Plot3D
        #------------------------------------------------------------
        self.FramePlot3D = FP3D.CFramePlot3D(self.FrameMain)
        self.FramePlot3D.grid(row=0, column=0)
        #------------------------------------------------------------
        return
    #---------------------------------------------------------------------
    # CWindowMain - Callback
    #---------------------------------------------------------------------
    def OnWMDeleteWindow(self):
        # debug print('OnWMWindowDelete')
        # self.WriteInitdata(DEF.NAME_INITFILE)
        if (None != self.OnFrameApplicationDelete):
            self.OnFrameApplicationDelete()
        self.FrameMain.destroy()
        return
    #---------------------------------------------------------------------
    # CWindowMain - Handler
    #---------------------------------------------------------------------
    def Execute(self):
        self.FrameMain.mainloop()
    #
    #
#
#
