#
#----------------------------------------------------------------------
#   FramePlot
#----------------------------------------------------------------------
import matplotlib.pyplot as PLT
from matplotlib.backends.backend_tkagg import (FigureCanvasTkAgg)#, NavigationToolbar2Tk)
import tkinter as TKI
#
import Define as DEF
#
class CFramePlot3D(TKI.Frame):
    #
    def __init__(self, parent):
        super().__init__(parent)
        self.Parent = parent
        self.Parent.rowconfigure(0, weight=1)
        self.Parent.columnconfigure(0, weight=1)
        self.Figure = PLT.figure(figsize=(DEF.DOTS_X / DEF.DOTSPERINCH,
                                          DEF.DOTS_Y / DEF.DOTSPERINCH),
                                 dpi=DEF.DOTSPERINCH)
        self.Axis = PLT.axes(projection='3d')
        self.Canvas = FigureCanvasTkAgg(self.Figure, master=self.Parent)
        self.Canvas.get_tk_widget().grid(row=0, column=0, sticky='nswe')
        #
        self.XL = DEF.LIMIT_X_LOW
        self.XH = DEF.LIMIT_X_HIGH
        self.YL = DEF.LIMIT_Y_LOW
        self.YH = DEF.LIMIT_Y_HIGH
        self.ZL = DEF.LIMIT_Z_LOW
        self.ZH = DEF.LIMIT_Z_HIGH
        #
        self.VX = []
        self.VY = []
        self.VZ = []
        #
        self.LineColor = 'r'
        self.LineWidth = 1.0
        self.LineStyle = 'solid'
        self.LineMarker = '.'
        #
        self.Elevation = 30.0
        self.Azimuth = 30.0
        #
        self.Rescale()
        #
        return
    #
    def SetVXYZ(self, vx, vy, vz):
        self.VX = vx
        self.VY = vy
        self.VZ = vz
    def SetXLH(self, xl, xh):
        self.XL = xl
        self.XH = xh
    def SetYLH(self, yl, yh):
        self.YL = yl
        self.YH = yh
    def SetZLH(self, zl, zh):
        self.ZL = zl
        self.ZH = zh
    def SetLineColor(self, value):
        self.LineColor = value
    def SetLineWidth(self, value):
        self.LineWidth = value
    def SetLineStyle(self, value):
        self.LineStyle = value
    def SetLineMarker(self, value):
        self.LineMarker = value
    def SetElevation(self, value):
        self.Elevation = value
    def SetAzimuth(self, value):
        self.Azimuth = value
    #
    def Rescale(self):
        self.Axis.cla() # !!! necessary !!!
        self.Axis.grid("both")
        self.Axis.axis('auto')
        self.Axis.set_aspect('auto', 'box')
        self.Axis.set_xlim(self.XL, self.XH)
        self.Axis.set_ylim(self.YL, self.YH)
        self.Axis.set_zlim(self.ZL, self.ZH)
        self.Axis.set_xlabel("x")
        self.Axis.set_ylabel("y")
        self.Axis.set_zlabel("z")
        self.Axis.view_init(elev=self.Elevation, azim=self.Azimuth)
        return
    #
    def Plot(self):
        self.Rescale()
        self.Axis.plot(self.VX, self.VY, self.VZ,
                       color=self.LineColor,
                       linewidth=self.LineWidth,
                       linestyle=self.LineStyle,
                       marker=self.LineMarker)
        self.Canvas.draw()
        return
    #
    #
#
#

















# #----------------------------------------------------------------------
# class CFramePlot3D(TKI.Frame):
#     #
#     def __init__(self, parent, sx, sy):
#         super().__init__(parent, width=sx, height=sy)
#         self.Parent = parent
#         self.Figure = PLT.figure(figsize=(4, 4), dpi=100)
#         #self.Figure = PLT.figure(figsize=(18, 12), dpi=100)
#         self.Axis = PLT.axes(projection='3d')
#         #
#         self.TimePeriod = DEF.TIMEPERIOD_IDLE_MS
#         self.XL = 0.0 #xl
#         self.XH = 20.0 #xh
#         self.YL = 0.0 #yl
#         self.YH = 20.0 #yh
#         self.ZL = -10.0 #zl
#         self.ZH = 10.0 #zh
#         self.Elevation = 30.0
#         self.Azimuth = 30.0
#         self.Axis.set_xlim([self.XL, self.XH])
#         self.Axis.set_ylim([self.YL, self.YH])
#         self.Axis.set_zlim([self.ZL, self.ZH])
#         self.VX = []
#         self.VY = []
#         self.VZ = []
#         self.Rescale()
#         self.Plot()
#         #
#     #
#     def SetVX(self, data):
#         self.VX = data
#     def SetVY(self, data):
#         self.VY = data
#     def SetVZ(self, data):
#         self.VZ = data
#     #
#     def SetXL(self, data):
#         self.XL = data
#     def SetXH(self, data):
#         self.XH = data
#     def SetYL(self, data):
#         self.YL = data
#     def SetYH(self, data):
#         self.YH = data
#     def SetZL(self, data):
#         self.ZL = data
#     def SetZH(self, data):
#         self.ZH = data
#     #
#     def SetElevation(self, data):
#         self.Elevation = data
#     def SetAzimuth(self, data):
#         self.Azimuth = data
#     #
#     def Rescale(self):
#         self.Axis.cla()
#         self.Axis.grid("both")
#         self.Axis.axis('auto') #'equal')
#         self.Axis.set_aspect('auto', 'box')#'equal', 'box')
#         self.Axis.set_xlabel("X [mm]")
#         self.Axis.set_ylabel("Y [mm]")
#         self.Axis.set_zlabel("Z [mm]")
#         #
#         self.Axis.set_xlim([self.XL, self.XH])
#         self.Axis.set_ylim([self.YL, self.YH])
#         self.Axis.set_zlim([self.ZL, self.ZH])
#         #
#         self.Axis.view_init(elev=self.Elevation, azim=self.Azimuth)
#     #
#     def Plot(self):
#         self.Rescale()
#         if (0 < len(self.VX)):
#             self.Axis.plot3D(self.VX, self.VY, self.VZ,
#                              linestyle='solid', color='#ff8888', linewidth=4.0)
#         return
#     #
#     #
# #
# #
