#
#----------------------------------------------------------------------
#   FramePlot
#----------------------------------------------------------------------
import random as RND
import numpy as NP
import matplotlib.pyplot as PLT
import tkinter as TKI
from matplotlib.backends.backend_tkagg \
    import FigureCanvasTkAgg #, NavigationToolbar2Tk
#
#----------------------------------------------------------------------
class CPlot():
    #
    def __init__(self, parent, periodrefresh, xl, xh, yl, yh, zl, zh):
        self.Parent = parent
        self.PeriodRefresh = periodrefresh
        self.OnRefreshPlot = None
        self.Figure = PLT.figure()
        self.Axis = PLT.axes(projection='3d') # figsize=(6, 6), dpi=100
        self.PlotData, = self.Axis.plot([], [], '')
        #
        self.Canvas = FigureCanvasTkAgg(self.Figure, master=self.Parent)
        #self.Toolbar = NavigationToolbar2Tk(self.Canvas, window)
        self.Canvas.get_tk_widget().pack(side=TKI.TOP, fill=TKI.BOTH, expand=1)
        self.OnInfo = None
        # later on init:
        self.Axis.cla()
        self.Axis.grid("both")
        self.Axis.axis('auto') #'equal')
        self.Axis.set_aspect('auto', 'box')#'equal', 'box')
        self.XL = xl
        self.XH = xh
        self.YL = yl
        self.YH = yh
        self.ZL = zl
        self.ZH = zh
        self.Axis.set_xlim([self.XL, self.XH])
        self.Axis.set_ylim([self.YL, self.YH])
        self.Axis.set_zlim([self.ZL, self.ZH])
        self.VX = []
        self.VY = []
        self.RefreshPlot()
    #
    def SetOnInfo(self, oninfo):
        self.OnInfo = oninfo
    #
    def SetOnRefreshPlot(self, onrefreshplot):
        self.OnRefreshPlot = onrefreshplot
    #
    def Info(self, text):
        if (None != self.OnInfo):
            self.OnInfo(text)
    #
    def RefreshPlot(self, ticks=0):
        ticks += 1
        if (None != self.OnRefreshPlot):
            PlotParameter = self.OnRefreshPlot(ticks, self.XL, self.XH,
                                               self.YL, self.YH,
                                               self.ZL, self.ZH,
                                               self.Figure, self.Axis)
            self.VX = PlotParameter[0]
            self.VY = PlotParameter[1]
            self.XL = PlotParameter[2]
            self.XH = PlotParameter[3]
            self.YL = PlotParameter[4]
            self.YH = PlotParameter[5]
        if (0 < len(self.VX)):
            self.PlotData.set_xdata(self.VX)
            self.PlotData.set_ydata(self.VY)
            self.Axis.set_xlim([self.XL, self.XH])
            self.Axis.set_ylim([self.YL, self.YH])
            self.Axis.set_zlim([self.ZL, self.ZH])
            self.Canvas.draw()
            self.Canvas.flush_events()
            self.Parent.after(self.PeriodRefresh, self.RefreshPlot, ticks)
        else:
            self.Parent.after(1000, self.RefreshPlot, ticks)
    #
    #
#
#
