import numpy as NUM
# NC from itertools import count
import matplotlib as MPL
import matplotlib.pyplot as PLT
from matplotlib.animation import FuncAnimation
import tkinter as TKI
#
import Define as DEF
import FrameMain as FMN
#
global VX, VY, Direction
VX = []
VY = []
Rmin = 4.0
Rmax = 5.0
XM = 5.0
YM = 5.0
Modulo = 128
Direction = True
#
def OnRefreshPlot(ticks, xlimitlow, xlimithigh, ylimitlow, ylimithigh, \
                  zlimitlow, zlimithigh, figure, axis):
    global VX, VY, Direction
    # Refresh Axis Values
    XLimitLow = DEF.LIMIT_X_LOW
    XLimitHigh = DEF.LIMIT_X_HIGH
    YLimitLow = DEF.LIMIT_Y_LOW
    YLimitHigh = DEF.LIMIT_Y_HIGH
    ZLimitLow = DEF.LIMIT_Z_LOW
    ZLimitHigh = DEF.LIMIT_Z_HIGH
    LineColor = '#FF0000FF' # (NUM.random.random(), NUM.random.random(), NUM.random.random())
    # Refresh Plot Values
    Ticks = ticks % Modulo
    A = 2 * NUM.pi * Ticks / Modulo
    R = Rmin + Ticks / Modulo * (Rmax - Rmin)
    X = DEF.XM + R * NUM.cos(A)
    Y = DEF.YM + R * NUM.sin(A)
    VX.append(X)
    VY.append(Y)
    if (0 == Ticks):
        Direction = not(Direction)
    if (Modulo - 2 < len(VX)):
        PLT.cla()
        PLT.grid("both")
        VX.pop(0)
        VY.pop(0)
    # Plot ... (Only at THIS point! Select here styles!)
    if (Direction):
        Elevation = Ticks / Modulo * 85.0
        Azimut = Ticks / Modulo * 90.0
    else:
        Elevation = (Modulo - Ticks) / Modulo * 85.0
        Azimut = (Modulo - Ticks) / Modulo * 90.0

    axis.view_init(elev=Elevation, azim=Azimut)
    axis.plot3D(VX, VY, linestyle='solid', color=LineColor, linewidth=0.8)
    return [VX, VY, XLimitLow, XLimitHigh, YLimitLow, YLimitHigh, ZLimitLow, ZLimitHigh]
#
#----------------------------------------------------------------------
#   Main
#----------------------------------------------------------------------
if ('__main__' == __name__):
    print('*** RealTimePlot2D: begin')
    #
    MainWindow = FMN.CFrameMain(TKI.Tk(), DEF.PERIOD_REFRESHPLOT_MS, \
                                DEF.LIMIT_X_LOW, DEF.LIMIT_X_HIGH, \
                                DEF.LIMIT_Y_LOW, DEF.LIMIT_Y_HIGH, \
                                DEF.LIMIT_Z_LOW, DEF.LIMIT_Z_HIGH)
    MainWindow.Plot.SetOnRefreshPlot(OnRefreshPlot)
    MainWindow.Execute();
    #
    print('*** RealTimePlot2D: end')
    #
    #
#
#
