#
# ------------------------------------------------------------------
#   GuiMinimal
# ------------------------------------------------------------------
#   Version: 01V01
#   Date   : 200618
#   Time   : 1012
#   Author : OMDevelop
#
import Define as DEF
import Uart as URT
import WindowMain as WM
#
UartPC = None
WindowMain = None
#
#------------------------------------------------------------------
# Global Callback
#------------------------------------------------------------------
def UartOnOpen():
    if (None != WindowMain):
        WindowMain.UartOnOpen()
#
def UartOnClose():
    if (None != WindowMain):
        WindowMain.UartOnClose()
#
def UartOnDataReceived(rxdata):
    if (None != WindowMain):
        WindowMain.UartOnDataReceived(rxdata)
#
def UartOnLineReceived(rxline):
    if (None != WindowMain):
        WindowMain.UartOnLineReceived(rxline)
#
###################################################################
# Main
###################################################################
if ('__main__' == __name__):
    print("*** " + DEF.APPLICATION_TITLE + ": begin")
    #
    UartPC = URT.CUart()
    UartPC.SetCBOnOpen(UartOnOpen)
    UartPC.SetCBOnClose(UartOnClose)
    UartPC.SetCBOnDataReceived(UartOnDataReceived)
    UartPC.SetCBOnLineReceived(UartOnLineReceived)
    #
    WindowMain = WM.CWindowMain()
    WindowMain.Initialise(UartPC)
    WindowMain.Execute()
    #
    print("*** " + DEF.APPLICATION_TITLE + ": end")
    #
#
#



