#
# ------------------------------------------------------------------
#   GuiMinimal
# ------------------------------------------------------------------
#   Version: 01V01
#   Date   : 200618
#   Time   : 1012
#   Author : OMDevelop
#
import tkinter as TK
from tkinter import ttk as TTK
from tkinter import messagebox as TKMB
from tkinter import filedialog as TKFD
#
import Define as DEF
import Initdata as ID
# import Task as TSK
import FrameUartConfiguration as FUC
import FrameUartDataflow as FUD
#

#------------------------------------------------------------------
#   Global Type - WindowMain
#------------------------------------------------------------------
class CWindowMain(TK.Tk):
    Uart = None
    #---------------------------------------------------------------------
    # CWindowMain - Constructor
    #---------------------------------------------------------------------
    def __init__(self):
        super().__init__()
        super().protocol("WM_DELETE_WINDOW", self.OnDeleteWindow)
        #
        self.Uart = None
        #
        self.title(DEF.APPLICATION_TITLE)
        # self.resizable(False, False)
        #
        # Menu
        self.Menu = TK.Menu(self)
        self.config(menu = self.Menu)
        # Menu - System
        self.MenuSystem = TK.Menu(self.Menu)
        self.Menu.add_cascade(label = "System", menu = self.MenuSystem)
        self.MenuSystem.add_command(label = "Read Initfile Default", \
                                    command = self.OnReadInitfileDefault)
        self.MenuSystem.add_command(label = "Read Initfile Dialog", \
                                    command = self.OnReadInitfileDialog)
        self.MenuSystem.add_separator()
        self.MenuSystem.add_command(label = "Write Initfile Default", \
                                    command = self.OnWriteInitfileDefault)
        self.MenuSystem.add_command(label = "Write Initfile Dialog", \
                                    command = self.OnWriteInitfileDialog)
        self.MenuSystem.add_separator()
        self.MenuSystem.add_command(label = "Exit Application", \
                                    command = self.OnExitApplication)
        # Menu - Device
        self.MenuDevice = TK.Menu(self.Menu)
        self.Menu.add_cascade(label = "Protocol", menu = self.MenuDevice)
        self.MenuDevice.add_command(label = "Write to File",
                                    command = self.OnProtocolWriteToFile)
        self.MenuDevice.add_separator()
        self.MenuDevice.add_command(label = "Clear All",
                                    command = self.OnProtocolClearAll)
        # Menu - Help
        self.MenuHelp = TK.Menu(self.Menu)
        self.Menu.add_cascade(label = "Help", menu = self.MenuHelp)
        self.MenuHelp.add_command(label = "Show About", command = self.OnShowAbout)
        #
        #
        #self.grid_propagate(0)
        #
        self.grid_rowconfigure(0, weight = 1)
        self.grid_columnconfigure(0, weight = 1)
        #self.grid_rowconfigure(1, weight = 1)
        #self.grid_rowconfigure(2, weight = 1)
        #self.grid_columnconfigure(1, weight = 1)
        #self.grid_columnconfigure(2, weight = 1)
        #
        #-------------------------------------------------------------------------------
        # Notebook - All
        #-------------------------------------------------------------------------------
        self.nbkMain = TTK.Notebook(self)
        self.nbkMain.grid(sticky = 'WENS')
        #self.nbkMain.pack(fill = TK.BOTH)
        #
        #-------------------------------------------------------------------------------
        # Notebook - Frame - UartConfiguration
        #-------------------------------------------------------------------------------
        self.FrameUartConfiguration = FUC.CFrameUartConfiguration(self.nbkMain)
        self.nbkMain.add(self.FrameUartConfiguration, text = "UartConfiguration")
        #
        #-------------------------------------------------------------------------------
        # Notebook - Frame - UartDataflow
        #-------------------------------------------------------------------------------
        self.FrameUartDataflow = FUD.CFrameUartDataflow(self.nbkMain)
        self.nbkMain.add(self.FrameUartDataflow, text = "UartDataflow")
        #
        #
    #---------------------------------------------------------------------
    # Property
    #---------------------------------------------------------------------
    def SetLinkUart(self, uart):
        self.Uart = uart
        self.FrameUartConfiguration.SetLinkUart(uart)
        self.FrameUartDataflow.SetLinkUart(uart)
    #---------------------------------------------------------------------
    # Callback
    #---------------------------------------------------------------------
    def UartOnOpen(self):
        self.FrameUartConfiguration.UartOnOpen()
        self.FrameUartDataflow.UartOnOpen()
    #
    def UartOnClose(self):
        self.FrameUartConfiguration.UartOnClose()
        self.FrameUartDataflow.UartOnClose()
    #
    def UartOnDataReceived(self, rxdata):
        self.FrameUartConfiguration.UartOnDataReceived(rxdata)
        self.FrameUartDataflow.UartOnDataReceived(rxdata)
    #
    def UartOnLineReceived(self, rxline):
        self.FrameUartConfiguration.UartOnLineReceived(rxline)
        self.FrameUartDataflow.UartOnLineReceived(rxline)
    #---------------------------------------------------------------------
    # CApplication - Initdata
    #---------------------------------------------------------------------
    def Initialise(self, uart):
        #self.Task = CTask() #self.Task.SetCBOnExecute(self.TaskOnExecute)
        self.SetLinkUart(uart)
        self.ReadInitdata(DEF.NAME_INITFILE)
        return
    #
    def ReadInitdata(self, filename):
        print("*** ReadInitdata: start")
        RID = ID.CReadInitdata()
        RID.Open(filename)
        X = RID.ReadValueInit(DEF.INITDATA_SECTION, DEF.NAME_X, DEF.INIT_X)
        Y = RID.ReadValueInit(DEF.INITDATA_SECTION, DEF.NAME_Y, DEF.INIT_Y)
        W = RID.ReadValueInit(DEF.INITDATA_SECTION, DEF.NAME_W, DEF.INIT_W)
        H = RID.ReadValueInit(DEF.INITDATA_SECTION, DEF.NAME_H, DEF.INIT_H)
        self.geometry('%dx%d+%d+%d' % (int(W), int(H), int(X), int(Y)))
        #
        STI = RID.ReadValueInit(DEF.INITDATA_SECTION, DEF.NAME_SELECTTABINDEX, \
                                DEF.INIT_SELECTTABINDEX)
        self.nbkMain.select(int(STI))
        #
        self.FrameUartConfiguration.ReadInitdata(RID)
        self.FrameUartDataflow.ReadInitdata(RID)
        #
        RID.Close()
        print("*** ReadInitdata: end")
        #
    #
    def WriteInitdata(self, filename):
        print("*** WriteInitdata: begin")
        X = self.winfo_x()
        Y = self.winfo_y()
        W = self.winfo_width()
        H = self.winfo_height()
        WID = ID.CWriteInitdata()
        WID.Open(filename)
        WID.WriteSection(DEF.INITDATA_SECTION)
        WID.WriteValue(DEF.INITDATA_SECTION, DEF.NAME_X, str(X))
        WID.WriteValue(DEF.INITDATA_SECTION, DEF.NAME_Y, str(Y))
        WID.WriteValue(DEF.INITDATA_SECTION, DEF.NAME_W, str(W))
        WID.WriteValue(DEF.INITDATA_SECTION, DEF.NAME_H, str(H))
        #
        STI = self.nbkMain.index('current')
        WID.WriteValue(DEF.INITDATA_SECTION, DEF.NAME_SELECTTABINDEX, str(STI))
        #
        self.FrameUartConfiguration.WriteInitdata(WID)
        self.FrameUartDataflow.WriteInitdata(WID)
        #
        WID.Close()
        print("*** WriteInitdata: end")
        #
    #
    #---------------------------------------------------------------------
    # CWindowMain - Callback
    #---------------------------------------------------------------------
    def OnDeleteWindow(self):
        try:
            self.WriteInitdata(DEF.NAME_INITFILE)
            self.Uart.Close()
        except:
            pass
        super().destroy()
    #
    def OnReadInitfileDefault(self):
        self.ReadInitdata(DEF.NAME_INITFILE)
    #
    def OnReadInitfileDialog(self):
        FT = (('Initfiles', '*.ini'),
              ('All files', '*.*'))
        FN = DEF.NAME_INITFILE
        FN = TKFD.askopenfilename(title = 'Read Initfile',
                                  initialdir = '../TerminalUart',
                                  filetypes = FT)
        self.ReadInitdata(FN)
    #
    def OnWriteInitfileDefault(self):
        self.WriteInitdata(DEF.NAME_INITFILE)
    #
    def OnWriteInitfileDialog(self):
        FT = (('Initfiles', '*.ini'),
              ('All files', '*.*'))
        FN = DEF.NAME_INITFILE
        FF = TKFD.asksaveasfile(initialfile = FN,
                                defaultextension = '.ini',
                                filetypes = FT)
        if (None != FF):
            FN = FF.name
            FF.close()
            self.WriteInitdata(FN)
    #
    def OnProtocolWriteToFile(self):
        FT = (('Protocolfiles', '*.txt'),
              ('All files', '*.*'))
        FN = DEF.NAME_PROTOCOLFILE
        FF = TKFD.asksaveasfile(initialfile = FN,
                                defaultextension = '.txt',
                                filetypes = FT)
        if (None != FF):
            FN = FF.name
            FF.close()
            self.FrameUartDataflow.SaveProtocolfile(FN)
    #
    def OnProtocolClearAll(self):
        self.FrameUartDataflow.ClearProtocols()
    #
    #---------------------------------------------------------------------
    # CWindowMain - Event
    #---------------------------------------------------------------------
    #
    def OnShowAbout(self):
        TKMB.showinfo("About", DEF.INFO_ABOUT)
    #
    def OnExitApplication(self):
        self.destroy()
    #
    #---------------------------------------------------------------------
    # CWindowMain - Handler
    #---------------------------------------------------------------------
    def Execute(self):
        self.mainloop()
    #
#
