#
# ------------------------------------------------------------------
#   Uart
# ------------------------------------------------------------------
#   Version: 02V00
#   Date   : 220916
#   Time   : 0934
#   Author : OMDevelop
#
import sys as SYS
import glob as GLB
import serial as SER
# import serial.tools.list_ports
import threading as THR
import time as TIM
#
#
# ------------------------------------------------------------------
#   Global Constant
# ------------------------------------------------------------------
#
COMPORTS =   ['COM1', 'COM2', 'COM3', 'COM4', 'COM5', 'COM6', 'COM7', 'COM8', 'COM9',
              'COM10', 'COM11', 'COM12', 'COM13', 'COM14', 'COM15', 'COM16', 'COM17',
              'COM18', 'COM19', 'COM20', 'COM21', 'COM22', 'COM23', 'COM24', 'COM25',
              'COM26', 'COM27', 'COM28', 'COM29']
#
BAUDRATES =  ['50', '75', '110', '134', '150', '200', '300', '600', '1200', '1800',
              '2400', '4800', '9600', '19200', '38400', '57600', '115200', '230400',
              '460800', '500000', '576000', '921600', '1000000', '1152000', '1500000',
              '2000000', '2500000', '3000000', '3500000', '4000000']
INDEX_BAUDRATE_DEFAULT = 16
#
PARITIES =   ['NONE', 'EVEN', 'ODD', 'MARK', 'SPACE']
INDEX_PARITY_DEFAULT = 0
#
DATABITS =   ['FIVEBITS', 'SIXBITS', 'SEVENBITS', 'EIGHTBITS']
INDEX_DATABITS_DEFAULT = 3
#
STOPBITS =   ['ONE', 'ONEPOINTFIVE', 'TWO']
INDEX_STOPBITS_DEFAULT = 0
#
HANDSHAKES = ['NONE', 'XONXOFF', 'RTSCTS', 'DSRDTR']
INDEX_HANDSHAKES_DEFAULT = 0
#
#------------------------------------------------------------
# Global Helper
#------------------------------------------------------------
def FindUartsAvailable():
    if SYS.platform.startswith('win'):
        Uarts = ['COM%s' % (i + 1) for i in range(256)]
    elif SYS.platform.startswith('linux') or SYS.platform.startswith('cygwin'):
        # this excludes your current terminal '/dev/tty'
        Uarts = GLB.glob('/dev/tty[A-Za-z]*')
    elif SYS.platform.startswith('darwin'):
        Uarts = GLB.glob('/dev/tty.*')
    else:
        raise EnvironmentError('Unsupported platform')
    UartsAvailable = []
    for Uart in Uarts:
        try:
            S = SER.Serial(Uart)
            S.close()
            UartsAvailable.append(Uart)
        except (OSError, SER.SerialException):
            pass
    return UartsAvailable
#
def TextBaudrate(text):
    switcher = {
        '50'     : 50,
        '75'     : 75,
        '110'    : 110,
        '134'    : 134,
        '150'    : 150,
        '200'    : 200,
        '300'    : 300,
        '600'    : 600,
        '1200'   : 1200,
        '1800'   : 1800,
        '2400'   : 2400,
        '4800'   : 4800,
        '9600'   : 9600,
        '19200'  : 19200,
        '38400'  : 38400,
        '57600'  : 57600,
        '100000' : 100000, # Futaba SBus
        '115200' : 115200,
        '230400' : 230400,
        '460800' : 460800,
        '500000' : 500000,
        '576000' : 576000,
        '921600' : 921600,
        '1000000': 1000000,
        '1152000': 1152000,
        '1500000': 1500000,
        '2000000': 2000000,
        '2500000': 2500000,
        '3000000': 3000000,
        '3500000': 3500000,
        '4000000': 4000000
    }
    return switcher.get(text, 115200)
#
def TextParity(text):
    switcher = {
        'NONE' : SER.PARITY_NONE,
        'EVEN' : SER.PARITY_EVEN,
        'ODD'  : SER.PARITY_ODD,
        'MARK' : SER.PARITY_MARK,
        'SPACE': SER.PARITY_SPACE
    }
    return switcher.get(text, SER.PARITY_NONE)
#
def TextDatabits(text):
    switcher = {
        'FIVEBITS' : SER.FIVEBITS,
        'SIXBITS' : SER.SIXBITS,
        'SEVENBITS': SER.SEVENBITS,
        'EIGHTBITS': SER.EIGHTBITS
    }
    return switcher.get(text, SER.EIGHTBITS)
#
def TextStopbits(text):
    switcher = {
        'ONE'         : SER.STOPBITS_ONE,
        'ONEPOINTFIVE': SER.STOPBITS_ONE_POINT_FIVE,
        'TWO'         : SER.STOPBITS_TWO
    }
    return switcher.get(text, SER.STOPBITS_ONE)
#
#
#-------------------------------------------------------------------
#   CUart
# ------------------------------------------------------------------
class CUart:
    # ---------------------------------------------------------------------
    # CUartClient - Constructor
    # ---------------------------------------------------------------------
    def __init__(self):
        self.Thread = None
        self.ContinueReading = False;
        self.CBOnOpen = None
        self.CBOnClose = None
        self.CBOnDataReceived = None
        self.CBOnLineReceived = None
        self.Serial = SER.Serial()
        self.Serial.port = ''
        self.Thread = None
    # ---------------------------------------------------------------------
    # CUartClient - Property
    # --------------------------------------------------------------------
    def SetCBOnOpen(self, cbonopen):
        self.CBOnOpen = cbonopen
    def SetCBOnClose(self, cbonclose):
        self.CBOnClose = cbonclose
    def SetCBOnDataReceived(self, cbondatareceived):
        self.CBOnDataReceived = cbondatareceived
        print('SetCBOnDataReceived')
    #
    def SetCBOnLineReceived(self, cbonlinereceived):
        self.CBOnLineReceived = cbonlinereceived
        print('SetCBOnLineReceived')
    #
    def IsOpen(self):
        return self.Serial.is_open
    # ---------------------------------------------------------------------
    # CUartClient - Callback - pySerial
    # ---------------------------------------------------------------------
    def CBSerialOnReceiveData(self):
        RxLine = ''
        self.ContinueReading = True
        #  Exception on Close : == self.Serial.is_open):
        while (self.ContinueReading):
            while (0 < self.Serial.inWaiting()):
                RxData = self.Serial.read(1).decode()
                if (None != self.CBOnDataReceived):
                    self.CBOnDataReceived(RxData)
                if (None != self.CBOnLineReceived):
                    if (('\n' == RxData) or ('\r' == RxData)):
                        if (0 < len(RxLine)):
                            # debug print(RxLine)
                            self.CBOnLineReceived(RxLine)
                        RxLine = ''
                    else:
                        RxLine += RxData
    # ---------------------------------------------------------------------
    # CUartClient - Handler
    # ---------------------------------------------------------------------
    def Open(self, comport, baudrate, parity, databits, stopbits, handshake):
        Result = False
        if not self.Serial.is_open:
            self.Serial.port = comport
            self.Serial.baudrate = TextBaudrate(baudrate)
            self.Serial.parity = TextParity(parity)
            self.Serial.bytesize = TextDatabits(databits)
            self.Serial.stopbits = TextStopbits(stopbits)
            self.Serial.timeout = 0.1
            self.Serial.xonxoff = False
            self.Serial.rtscts = False
            self.Serial.dsrdtr = False
            if ('XONXOFF' == handshake):
                self.Serial.xonxoff = True
            if ('RTSCTS' == handshake):
                self.Serial.rtscts = True
            if ('DSRDTR' == handshake):
                self.Serial.dsrdtr = True
            self.Serial.open()
            #
            if (None == self.Thread):
                self.Thread = THR.Thread(target = self.CBSerialOnReceiveData)
            self.Thread.start()
            #
            Result = self.Serial.is_open
            #
        print('UartPort[' + comport + ']BR[' + baudrate + ']PA[' + \
              parity + ']DB[' + databits + ']SB[' + stopbits + ']HS[' + \
              handshake + '] IsOpened[' + str(Result) + ']')
        if (Result):
            if (None != self.CBOnOpen):
                self.CBOnOpen()
        return Result
    #
    def Close(self, comport = 'COM'):
        Result = False
        CP = self.Serial.port
        if self.Serial.is_open:
            # self.Serial.flush()
            self.ContinueReading = False
            TIM.sleep(0.1)
            self.Serial.close()
            #
            if (not (None == self.Thread)):
                self.Thread.running = False
            self.Thread = None
            #
            Result = not self.Serial.is_open
        #
        print('UartPort[' + CP + '] IsClosed[' + str(Result) + ']')
        if (Result):
            if (None != self.CBOnClose):
                self.CBOnClose()
        return Result
    #
    def WriteLine(self, line):
        if self.Serial.is_open:
            Line = line + '\r\n'
            self.Serial.write(Line.encode())
    #
    #
#
#

