#
import threading as THR
import enum as ENU
#
class EStateThread(ENU.Enum):
    stIdle = 0
    stBusy = 1
    stEnd = 2
#
def CBOnExecute(thread):
    if (None != thread.OnBusy):
        thread.OnBusy(thread)
    if (None != thread.OnEnd):
        thread.OnEnd(thread)
#
class CThread():
    #
    def __init__(self, onstart, onbusy, onabort, onend):
        self.State = EStateThread.stIdle
        self.Thread = THR.Thread(target=CBOnExecute, args=(self,))
        self.OnStart = onstart
        self.OnBusy = onbusy
        self.OnAbort = onabort
        self.OnEnd = onend
    #
    def Start(self):
        self.State = EStateThread.stBusy
        if (None != self.OnStart):
            self.OnStart(self)
        self.Thread.start()
        return   
    #
    def Abort(self):
        self.State = EStateThread.stEnd
        if (None != self.OnAbort):
            self.OnAbort(self)
        return