#
#----------------------------------------------------------------------
#   FrameMain
#----------------------------------------------------------------------
import tkinter as TKI
#
import FrameImage as FI
from PIL import Image as IMG
from PIL import ImageTk as ITK

#
#----------------------------------------------------------------------
class CFrameMain():
    #
    BORDER_X = 2
    BORDER_Y = 3
    #
    def __init__(self, tk):
        self.TK = tk        
        self.TK.title("Graph")
        self.TK.geometry("1024x768+-1080+20")#"800x400")
        self.TK.rowconfigure(index=0, weight=0)
        self.TK.rowconfigure(index=1, weight=0) # Plot!
        self.TK.columnconfigure(index=0, weight=0) # Plot!
        self.TK.columnconfigure(index=1, weight=0)
        self.TK.columnconfigure(index=2, weight=0)
        self.TK.columnconfigure(index=3, weight=0)
        #------------------------------------------------------------
        # Menu
        self.MenuMain = TKI.Menu(self.TK)
        self.TK.config(menu=self.MenuMain)
        self.MenuSystem = TKI.Menu(self.MenuMain, tearoff=0)
        self.MenuMain.add_cascade(label='System', menu=self.MenuSystem)
        self.MenuSystem.add_command(label='New', command=self.OnSystemNew)
        self.MenuSystem.add_separator()
        self.MenuSystem.add_command(label='Quit', command=self.OnSystemQuit)
        #------------------------------------------------------------
        # Top
        self.FT = TKI.Frame(self.TK, bg='#888888', padx=1, pady=1)        
        self.FT.place(x=0, y=0, w=480, h=64)
        #
        self.SBR = TKI.Scrollbar(self.FT, orient='horizontal', bg="#DDDDDD", \
                                 command=self.OnSBRScroll)
        self.SBR.place(x=2, y=2, w=395)
        self.ER = TKI.Entry(self.FT, width=10)
        self.ER.place(x=400, y=1)
        #
        self.SBG = TKI.Scrollbar(self.FT, orient='horizontal', bg="#DDDDDD", \
                                 command=self.OnSBGScroll)
        self.SBG.place(x=2, y=22, w=395)
        self.EG = TKI.Entry(self.FT, width=10)
        self.EG.place(x=400, y=21)
        #
        self.SBB = TKI.Scrollbar(self.FT, orient='horizontal', bg="#DDDDDD", \
                                 command=self.OnSBBScroll)
        self.SBB.place(x=2, y=42, w=395)
        self.EB = TKI.Entry(self.FT, width=10)
        self.EB.place(x=400, y=41)        
        #
        #------------------------------------------------------------
        # Image
        self.FI = TKI.Frame(self.TK, bg='#CCCCCC', padx=1, pady=1)
        self.FI.place(x=0, y=64, w=640, h=480)
        self.FrameImage = FI.CFrameImage(self.FI)
        self.FrameImage.place(x=0, y=0)
        #
        return
    #
    def OnSBRScroll(self, *L):
        Operation, Value = L[0], L[1]
        self.ER.delete(0, 'end')
        SP = 0.0
        GS = self.SBR.get()
        DG = 0.004
        GL = float(GS[0])
        GH = max(GL + DG, float(GS[1]))
        if ('moveto' == Operation):
            SP = float(Value)
            self.SBR.set(SP, SP + DG)
        if ('scroll' == Operation):
            SP = GL + float(Value) * 5 * DG
            self.SBR.set(SP, SP + DG)
        ISP = max(0, min(255, int(255 * SP)))
        self.ER.insert(0, '{0}'.format(ISP))
        #
        #self.OnRescaleImage()
    #
    def OnSBGScroll(self, *L):
        Operation, Value = L[0], L[1]
        self.EG.delete(0, 'end')
        SP = 0.0
        GS = self.SBG.get()
        DG = 0.004
        GL = float(GS[0])
        GH = max(GL + DG, float(GS[1]))
        if ('moveto' == Operation):
            SP = float(Value)
            self.SBG.set(SP, SP + DG)
        if ('scroll' == Operation):
            SP = GL + float(Value) * 5 * DG
            self.SBG.set(SP, SP + DG)
        ISP = max(0, min(255, int(255 * SP)))
        self.EG.insert(0, '{0}'.format(ISP))
        #
        #self.OnRescaleImage()
    #
    def OnSBBScroll(self, *L):
        Operation, Value = L[0], L[1]
        self.EB.delete(0, 'end')
        SP = 0.0
        GS = self.SBB.get()
        DG = 0.004
        GL = float(GS[0])
        GH = max(GL + DG, float(GS[1]))
        if ('moveto' == Operation):
            SP = float(Value)
            self.SBB.set(SP, SP + DG)
        if ('scroll' == Operation):
            SP = GL + float(Value) * 5 * DG
            self.SBB.set(SP, SP + DG)
        ISP = max(0, min(255, int(255 * SP)))
        self.EB.insert(0, '{0}'.format(ISP))
        #
        #self.OnRescaleImage()

        #
    #def OnRescaleImage(self):
    #    return
        # self.ImageSource = IMG.open('aaa.png')
        # IRGB = self.ImageSource.load()
        # #IRGB = self.ImageSource #.convert('RGB')
        # for IX in range(0, 100):
        #     R, G, B = IRGB[IX, 10] # IRGB.getpixel((IX, 10))
        #     R = 1
        #     IRGB[IX, 10] = (R, G, B)
        # IR = IRGB.resize((640, 480), IMG.ANTIALIAS)
        # self.ImageResized = ITK.PhotoImage(IR)
        # self.ImageBox = TKI.Label(self.FI, bg='red', image=self.ImageResized)
        # self.ImageBox.place(x=0, y=0, w=640, h=480)
        



    #
    def OnInfo(self, text):
        # debug print('Event[{0}]'.format(text))
        self.lblInfo['text'] = '{0}'.format(text)
    #
    def OnBCClicked(self):
        self.OnInfo('abc')
        # self.Plot.Info('uvw')
    #
    def OnSystemNew(self):
        # ...
        return
    def OnSystemQuit(self):
        self.TK.destroy()
    #
    def Execute(self):
        self.TK.mainloop()
    #
    def LoadImage(self, filename):
        self.FrameImage.LoadImage(filename)
        # self.ImageSource = IMG.open(filename)
        # IR = self.ImageSource.resize((640, 480), IMG.ANTIALIAS)
        # self.ImageResized = ITK.PhotoImage(IR)
        # self.ImageBox = TKI.Label(self.FI, bg='red', image=self.ImageResized)
        # self.ImageBox.place(x=0, y=0, w=640, h=480)
        #

    #
#
#----------------------------------------------------------------------
#   Main
#----------------------------------------------------------------------
# import runpy
# runpy.run_path(path_name='RealTimePlot.py')
# exec(open('RealTimePlot.py').read())
#
if ('__main__' == __name__):
    #
    print('*** FrameMain: begin')
    #
    WindowMain = CFrameMain(TKI.Tk())
    WindowMain.Execute();
    #
    print('*** FrameMain: end')
    #
#


