import tkinter as TKI
from tkinter import ttk as TTK
#
import FrameChild as FRC
import FrameTest as FRT
#
TITLE_APPLICATION = 'FrameHierarchy'
#
class CFrameApplication(TKI.Frame):
    def __init__(self, frameparent, *args, **kwargs):
        TKI.Frame.__init__(self, frameparent, *args, **kwargs)
        self.FrameParent = frameparent
        #
        self.FrameParent.geometry('1000x600+2022+22')
        self.FrameParent.title(TITLE_APPLICATION)
        #
        #--------------------------------------------------------
        # Common
        #--------------------------------------------------------
        self.FrameParent.rowconfigure(0, weight=6)
        self.FrameParent.rowconfigure(1, weight=6)
        self.FrameParent.columnconfigure(0, weight=6)
        self.FrameParent.columnconfigure(1, weight=6)
        #--------------------------------------------------------
        # F00
        #--------------------------------------------------------
        self.btnTest00 = TKI.Button(self.FrameParent, text='Test00', fg="red")
        self.btnTest00.grid(row=0, column=0, sticky='wnes')
        #--------------------------------------------------------
        # F01
        #--------------------------------------------------------
        self.btnTest01 = FRC.CFrameChild(self.FrameParent)
        self.btnTest01.grid(row=0, column=1, sticky='wnes')
        #--------------------------------------------------------
        # F10
        #--------------------------------------------------------
        self.frmTest = FRT.CFrameTest(self.FrameParent)
        self.frmTest.grid(row=1, column=0, sticky='wnes')
        #--------------------------------------------------------
        # F11
        #--------------------------------------------------------
        self.ntbMain = TTK.Notebook(self.FrameParent) # bg='#ffAA66')
        self.ntbMain.grid(row=1, column=1, sticky='wnes')
        #
        self.tbsChild = FRC.CFrameChild(self.ntbMain)
        self.ntbMain.add(self.tbsChild, text='Tabsheet: Child')
        #
        self.tbsTest = FRT.CFrameTest(self.ntbMain)
        self.ntbMain.add(self.tbsTest, text='Tabsheet: Test')
        #
        return
    #
    def Execute(self):
        self.FrameParent.mainloop()
