#
#----------------------------------------------------------------------
#   ListComPorts
#----------------------------------------------------------------------
import sys
import serial
import serial.tools.list_ports
#
if ('__main__' == __name__):
    print('*** ListComPorts: begin')
    #
    ComPorts = serial.tools.list_ports.comports()
    print('------------------------')
    print('List of all ComPorts:')
    CPSelected = None
    for CP in ComPorts:
        if ((None != CP.pid) and (None != CP.vid)):
            print('  Name[{}] Description[{}]'.format(CP.name, CP.description))
            try:
                SS = serial.Serial(CP.name)
                SS.close()
                if (None == CPSelected):
                    CPSelected = CP
            except (OSError, serial.SerialException):
                pass
        else:
            print('  INVALID! Name[{}] Description[{}]'.format(CP.name, CP.description))
    #        
    if (None == CPSelected):
        print('Error: No ComPort available!')
        sys.exit()
    print('ComPort selected: ', CPSelected.name)
    print('------------------------')
    print('*** ListComPorts: end')
    #
#
                
    