#
import time as TIM
import threading as THR
#
import Task as TSK
#
#---------------------------------------------------------
# Constant
#---------------------------------------------------------
COUNT_ACTIONCYCLE = 3
#
#---------------------------------------------------------
# Field - Global
#---------------------------------------------------------
#---------------------------------------------------------
# Callback - Task - Refresh
#---------------------------------------------------------
def OnTaskRefreshStart(task):
    #print('OnTaskRefresh-Start[{0}]: begin'.format(task.ID))
    task.GetArguments()[0].clear()
    #print('OnTaskRefresh-Start[{0}]: end'.format(task.ID))
    return
def OnTaskRefreshAbort(task):
    #print('OnTaskRefresh-Abort[{0}]: begin'.format(task.ID))
    task.GetArguments()[0].set() # stop waiting on abort!
    #print('OnTaskRefresh-Abort[{0}]: end'.format(task.ID))
    return
def OnTaskRefreshExecute(task):
    #print('OnTaskRefresh-Execute[{0}]: begin'.format(task.ID))
    print('### TaskRefresh - Busy...')
    TIM.sleep(3.0)
    print('### TaskRefresh - SetEvent!')
    task.GetArguments()[0].set()
    #print('OnTaskRefresh-Execute[{0}]: end'.format(task.ID))
    return False
#---------------------------------------------------------
# Callback - Task - Action
#---------------------------------------------------------
def OnTaskActionStart(task):
    #print('OnTaskAction-Start[{0}]: begin'.format(task.ID))
    #print('OnTaskAction-Start[{0}]: end'.format(task.ID))
    return
def OnTaskActionAbort(task):
    #print('OnTaskAction-Abort[{0}]: begin'.format(task.ID))
    TaskRefresh.Abort()
    #print('OnTaskAction-Abort[{0}]: end'.format(task.ID))
    return
def OnTaskActionExecute(task):
    print('OnTaskAction-Execute[{0}]<{1}>: begin'.format(task.ID, task.GetCounter()))
    print('### TaskAction - Start Refresh and Wait for Event...')
    TaskRefresh.Start()
    task.GetArguments()[0].wait()
    print('### TaskAction - Refresh Finished (Event set)')
    #print('OnTaskAction-Execute[{0}]: end'.format(task.ID))
    return (task.GetCounter() <  COUNT_ACTIONCYCLE)
#---------------------------------------------------------
# Main
#---------------------------------------------------------
if ('__main__' == __name__):
    print('*** MainProgram-TaskEvent: begin')
    #
    EventReady = THR.Event()
    #
    TaskRefresh = TSK.CTask('TaskRefresh',
                            OnTaskRefreshStart,
                            OnTaskRefreshAbort,
                            OnTaskRefreshExecute,
                            (EventReady,))
    TaskAction = TSK.CTask('TaskAction',
                           OnTaskActionStart,
                           OnTaskActionAbort,
                           OnTaskActionExecute,
                           (EventReady,))
    TaskAction.Start()
    #
    print('*** MainProgram-TaskEvent: end')
    #
    #
#
#
##########################################################
#
#
