#
# Syntax-Arguments: <headerid> <rxipport> <txipaddress> <txipport>
#
# WindowsPC[192.168.178.33] <-> # WindowsPC[192.168.178.33]:
# WinPC: python CheckUdpClientServer.py Windows 4321 192.168.178.33 4321


# WindowsPC[192.168.178.33] <-> UbuntuPC[192.168.178.48]
# WinPC: python CheckUdpClientServer.py Windows 5001 192.168.178.48 5000
# LinPC: python CheckUdpClientServer.py Ubuntu  5000 192.168.178.33 5001 
#
import sys
import time
import socket as SKT
#
import Thread as THR
import UdpClientServer as UCS
#
UDP_HEADERID = 'UDPHID'
#-----------------------------------------------------------
#   UDP - TxD - TransmitData
#-----------------------------------------------------------
UDP_IPADDRESS_TX = '127.0.0.255'
UDP_IPPORT_TX = 5000
#
#-----------------------------------------------------------
#   UDP - RxD - ReceiveData
#-----------------------------------------------------------
UDP_IPADDRESS_LOCAL = '127.0.0.1' # dummy
UDP_IPPORT_RX = 5000
#   
#-----------------------------------------------------------
#   Callback - UdpClient
#-----------------------------------------------------------
def CBOnTxData(udpclientserver, txdata):
    Line = 'CBOnTxData[{}]<{}>'.format(udpclientserver.GetHeaderID(), txdata)
    print(Line)
    return
#
def CBOnRxData(udpclientserver, rxdata):
    Line = 'CBOnRxData[{}]<{}>'.format(udpclientserver.GetHeaderID(), rxdata)
    print(Line)
    return
#
def CBOnStart(udpclientserver):
    # debug print('Main-CBOnStart')
    return
#
def CBOnBusy(udpclientserver):
    # debug print('Main-CBOnBusy')
    return
#
def CBOnAbort(udpclientserver):
    # debug print('Main-CBOnAbort')
    return
#
def CBOnEnd(udpclientserver):
    # debug print('Main-CBOnEnd')
    return
#   
#-----------------------------------------------------------
#   Main
#-----------------------------------------------------------
if ('__main__' == __name__):
    #
    print('*** CheckUdpClientServer: begin')
    if (5 <= len(sys.argv)):
        # Analyse Arguments für Tx/Rx-Parameter
        UDP_HEADERID = sys.argv[1]
        # RX
        UDP_IPPORT_RX = int(sys.argv[2])
        # TX
        UDP_IPADDRESS_TX = sys.argv[3]
        UDP_IPPORT_TX = int(sys.argv[4])
    #
    UdpCS = UCS.CUdpClientServer(UDP_HEADERID, UDP_IPPORT_RX,
                                 UDP_IPADDRESS_TX, UDP_IPPORT_TX, 
                                 CBOnTxData, CBOnRxData, 
                                 CBOnStart, CBOnBusy, CBOnAbort, CBOnEnd)
    #        
    print('{}: TxIP-Address[{}]-Port[{}]'.format(UdpCS.GetHeaderID(), 
                                                 UdpCS.GetIPAddressTX(), 
                                                 UdpCS.GetIPPortTX()))
    print('{}: RxIP(local)-Address[{}]-Port[{}]'.format(UdpCS.GetHeaderID(), 
                                                 UdpCS.GetIPAddressRXLocal(),
                                                 UdpCS.GetIPPortRX()))
    UdpCS.Open()
    for I in range(0, 6):
        time.sleep(5.0)
        UdpCS.Transmit('{}[{}]'.format(I,UdpCS.GetHeaderID()))
    time.sleep(1.0)
    UdpCS.Close()
    #
    print('*** CheckUdpClientServer: end')
    #
#