//
#ifndef AM2302_h
#define AM2302_h
//
#include "Arduino.h"
//
#define MIN_INTERVAL 2000 
#define TIMEOUT UINT32_MAX
//
class CAM2302
{
private:
  uint8_t data[5];
  uint8_t _pin;
  uint32_t _lastreadtime, _maxcycles;
  bool _lastresult;
  uint8_t pullTime; 
  //
  uint32_t ExpectPulse(bool level);
  //
  public:
  CAM2302(uint8_t pin); //, uint8_t type, uint8_t count = 6);
  void Open(uint8_t usec = 55);
  float ReadTemperature(void);
  float ConvertCtoF(float);
  float ConvertFtoC(float);
  float ReadHeatIndex(void);
  float ComputeHeatIndex(float temperature, float humidity);
  float ReadHumidity(bool force = false);
  bool Read(bool force = false);
};
//
class InterruptLock 
{
public:
  InterruptLock() 
  {
#if !defined(ARDUINO_ARCH_NRF52)
    noInterrupts();
#endif
  }
  ~InterruptLock() 
  {
#if !defined(ARDUINO_ARCH_NRF52)
    interrupts();
#endif
  }
};
//
#endif // AM2302_h
//