#include <Arduino.h>
//
#include "AM2302.h"
//
#include "Type.h"
#include "RxFrameLRS.h"
//
//---------------------------------------------------
//  Global Define
//---------------------------------------------------
#define UartPC Serial
#define UartLRS Serial2
//
const int PIN_LEDSYSTEM = 2;
const int PIN_RXD2 = 16;
const int PIN_TXD2 = 17;
//
// #define DHTTYPE AM2302 
// const uint8_t PIN_AM2302_DATA = 0;
//
//---------------------------------------------------
//  Global Field
//---------------------------------------------------
// CAM2302 AM2302(PIN_AM2302_DATA); 
// int Check;
// float Humidity;
// float Temperature;
//
CRxFrameLRS RxFrameLRS;

void RxFrameLRSOnTransmitLine(PCharacter line)
{
  UartPC.println(line);
  delay(1000);
  UartLRS.println(line);
  delay(1000);
}

//
//---------------------------------------------------
//  Setup
//---------------------------------------------------
void setup() 
{ // Uart
  UartPC.begin(115200);
  UartLRS.begin(115200, SERIAL_8N1, PIN_RXD2, PIN_TXD2);
  delay(333);
  UartPC.println("#********************" );
  UartPC.println("#* Esp32LRSEmulator *");
  UartPC.println("#* Version : 01V02  *");
  UartPC.println("#* Date    : 211123 *");
  UartPC.println("#* Time    : 0933   *");
  UartPC.println("#* Author  : FM     *");
  UartPC.println("#********************" );
  // AM2302
  // AM2302.Open();
  //
  RxFrameLRS.Initialise();
  RxFrameLRS.SetOnTransmitLine(RxFrameLRSOnTransmitLine);
#ifdef LRSMODE_BACKGROUNDNOISE
  RxFrameLRS.InitialiseBackgroundNoise("Backgnd", "211119", "200400", 
                                       45.2f, 5000, -18.0f, +76.4f);
#endif
#ifdef LRSMODE_SAWTOOTHNOISE
  RxFrameLRS.InitialiseSawtoothNoise("SawNoise", "211120", "101103", 
                                     45.2f, 1000, -18.0f, +76.4f);
#endif
#ifdef LRSMODE_SINUSNOISE
  RxFrameLRS.InitialiseSinusNoise("SinNoise", "211120", "101103", 
                                  45.2f, 5000, -18.0f, +76.4f);
#endif
#ifdef LRSMODE_MEASUREMENT
  RxFrameLRS.InitialiseMeasurement("Measure", "211120", "101103", 
                                   45.2f, 5000, -18.0f, +76.4f);
#endif
#ifdef LRSMODE_PATHTHROUGH
  RxFrameLRS.InitialisePathThrough("PThrough", "211120", "101103", 
                                   45.2f, 5000, -18.0f, +76.4f);
#endif
}
//
//---------------------------------------------------
//  Loop
//---------------------------------------------------
void loop() 
{
#ifdef LRSMODE_BACKGROUNDNOISE
  RxFrameLRS.ExecuteBackgroundNoise();
#endif
#ifdef LRSMODE_SAWTOOTHNOISE
  RxFrameLRS.ExecuteSawtoothNoise();
#endif
#ifdef LRSMODE_SINUSNOISE
  RxFrameLRS.ExecuteSinusNoise();
#endif
#ifdef LRSMODE_MEASUREMENT
  RxFrameLRS.ExecuteMeasurement();
#endif
#ifdef LRSMODE_PATHTHROUGH
  RxFrameLRS.ExecutePathThrough();
#endif
}


   