#
#----------------------------------------------------------------------
#   FrameMain
#----------------------------------------------------------------------
import tkinter as TKI
#
import FramePlot as FP
#
#----------------------------------------------------------------------
class CFrameMain():
    #
    BORDER_X = 2
    BORDER_Y = 3
    #
    def __init__(self, tk, periodrefresh, xl, xh, yl, yh):
        self.TK = tk        
        self.TK.title("Graph")
        WW = 1024
        WH = 768                    
        WX = -WW - 32
        WY = +20
        self.TK.geometry('%dx%d+%d+%d' % (WW, WH, WX, WY))
        self.TK.rowconfigure(index=0, weight=0)
        self.TK.rowconfigure(index=1, weight=1) # Plot!
        self.TK.columnconfigure(index=0, weight=1) # Plot!
        self.TK.columnconfigure(index=1, weight=0)
        self.TK.columnconfigure(index=2, weight=0)
        self.TK.columnconfigure(index=3, weight=0)
        #------------------------------------------------------------
        # Menu
        self.MenuMain = TKI.Menu(self.TK)
        self.TK.config(menu=self.MenuMain)
        self.MenuSystem = TKI.Menu(self.MenuMain, tearoff=0)
        self.MenuMain.add_cascade(label='System', menu=self.MenuSystem)
        self.MenuSystem.add_command(label='New', command=self.OnSystemNew)
        self.MenuSystem.add_separator()
        self.MenuSystem.add_command(label='Quit', command=self.OnSystemQuit)
        #------------------------------------------------------------
        # Top
        self.FT = TKI.Frame(self.TK, bg='#888888', padx=1, pady=1)        
        self.FT.grid(row=0, column=0, sticky='nsew')
        #
        self.BA = TKI.Button(self.FT, text="Action A", \
                             bg="#DDDDDD", fg="#000000")
        self.BA.grid(row=0, column=0, sticky='W', \
                     padx=self.BORDER_X, pady=self.BORDER_Y)
        self.BB = TKI.Button(self.FT, text="Action B", \
                             bg="#DDDDDD", fg="#000000")
        self.BB.grid(row=0, column=1, sticky='W', \
                     padx=self.BORDER_X, pady=self.BORDER_Y)
        self.BC = TKI.Button(self.FT, text="Action C", \
                             bg="#DDDDDD", fg="#000000", \
                             command=self.OnBCClicked)
        self.BC.grid(row=0, column=2, sticky='W', \
                     padx=self.BORDER_X, pady=self.BORDER_Y)
        self.lblInfo = TKI.Label(self.FT, text="---", \
                             bg="#DDDDDD", fg="#000000")
        self.lblInfo.grid(row=0, column=3, sticky='W', \
                     padx=self.BORDER_X, pady=self.BORDER_Y)
        #------------------------------------------------------------
        # Plot
        self.FP = TKI.Frame(self.TK, bg='#AAAAAA', padx=1, pady=1)
        self.FP.grid(row=1, column=0, columnspan=5, sticky='nesw')
        #
        # self.Plot = FP.CPlot(self.FP, periodrefresh, xl, xh, yl, yh)
        # self.Plot.SetOnInfo(self.OnInfo)
        #------------------------------------------------------------
        # # Bottom
        # self.FB = TKI.Frame(self.TK, bg='#888888', padx=1, pady=1)        
        # self.FB.grid(row=2, column=0, sticky='nsew')
        # #
        # self.BU = TKI.Button(self.FB, text="Action U", \
        #                       bg="#DDDDDD", fg="#000000")
        # self.BU.grid(row=0, column=0, sticky='W', \
        #               padx=self.BORDER_X, pady=self.BORDER_Y)
        # self.BV = TKI.Button(self.FB, text="Action V", \
        #                       bg="#DDDDDD", fg="#000000")
        # self.BV.grid(row=0, column=1, sticky='W', \
        #               padx=self.BORDER_X, pady=self.BORDER_Y)
        # self.BW = TKI.Button(self.FB, text="Action W", \
        #                       bg="#DDDDDD", fg="#000000")
        # self.BW.grid(row=0, column=2, sticky='W', \
        #               padx=self.BORDER_X, pady=self.BORDER_Y)
        #
        return
    #
    def OnInfo(self, text):
        # debug print('Event[{0}]'.format(text))
        self.lblInfo['text'] = '{0}'.format(text)
    #
    def OnBCClicked(self):
        self.OnInfo('abc')
        self.Plot.Info('uvw')
    #
    def OnSystemNew(self):
        # ...
        return
    def OnSystemQuit(self):
        self.TK.destroy()
    #
    def Execute(self):
        self.TK.mainloop()
#
#----------------------------------------------------------------------
#   Main
#----------------------------------------------------------------------
# import runpy
# runpy.run_path(path_name='RealTimePlot.py')
# exec(open('RealTimePlot.py').read())
#
if ('__main__' == __name__):
    #
    print('*** FrameMain: begin')
    #
    WindowMain = CFrameMain(TKI.Tk())
    WindowMain.Execute();
    #
    print('*** FrameMain: end')
    #
#


