#
#----------------------------------------------------------------------
#   PcLRSMeasurement
#----------------------------------------------------------------------
import random as RND
import numpy as NP
import tkinter as TKI
from time import sleep as Sleep
#
import FrameMain as FM
import Thread as THR
import Uart as UT # conda|pip install pyserial
import Convert as CV
#
TIME_START = 0.0 # [s]
TIME_PERIOD = 30.0 # [s]
TIME_DURATION = 300.0 # [s]
AMPLITUDE_FIXED = 1.0 # [unit]
PHASE = 0 # [rad]
PERIOD_REFRESHPLOT = 1 # [ms]
global VX
global VY
global ResetPlot
global AmplitudeHigh
global AmplitudeLow
VX = []
VY = []
ResetPlot = True
AmplitudeHigh = AMPLITUDE_FIXED
AmplitudeLow = -AMPLITUDE_FIXED
#
#----------------------------------------------------------------------
#   PlotData - UartAcquisition
#----------------------------------------------------------------------
def UartOnReadData(id, thread):
    global ResetPlot
    global VX
    global VY    
    while (thread.IsBusy()):
        RxLine = UartEsp32.ReadLine()
        if (0 < len(RxLine)):
            X = 0.0
            Y = 0.0
            #!!!! -> TerminalWidget !!! print('RxLine<<<' + RxLine + '>>>')
            if (Convert.Tokenize(RxLine)):
                X = float(Convert.GetToken(1))
                if (X <= 0.0):
                    ResetPlot = True
                Y = float(Convert.GetToken(2))
                LI = len(VX) - 1
                if (0 <= LI):
                    if (VX[LI] < X):
                        VX.append(X)
                        VY.append(Y)
                else:
                    VX.append(X)
                    VY.append(Y)
                    
        #
        Sleep(.010)
#
def OnRefreshValues(ticks, xl, xh, yl, yh):
    # !!! [xl, xh, yl, yh] = SimulateValues(time, xl, xh, yl, yh)
    global ResetPlot
    global VX
    global VY
    global AmplitudeHigh
    global AmplitudeLow
    if (ResetPlot):
        ResetPlot = False
        xl = TIME_START
        xh = TIME_PERIOD
        AmplitudeHigh = +AMPLITUDE_FIXED
        AmplitudeLow = -AMPLITUDE_FIXED
        yl = AmplitudeLow
        yh = AmplitudeHigh
        VX = []
        VY = []
        return [VX, VY, xl, xh, yl, yh]    
    LI = len(VX) - 1
    if (0 < LI):
        if (TIME_PERIOD <= VX[LI]):
            xh = VX[LI]
        Y = 1.1 * VY[LI]
        if (AmplitudeHigh < Y):
            AmplitudeHigh = 1.1 * VY[LI]
            yh = AmplitudeHigh
        if (Y < AmplitudeLow):
            AmplitudeLow = 1.1 * VY[LI]
            yl = AmplitudeLow 
    return [VX, VY, xl, xh, yl, yh]
#
#----------------------------------------------------------------------
#   Main
#----------------------------------------------------------------------
if ('__main__' == __name__):
    print('*** PcLRSMeasurement: begin')
    #
    ResetPlot = True
    VX = []
    VY = []
    # uart
    # UartEsp32 = UT.CUart('UC', 'COM21')
    #try:
        # convert
        # Convert = CV.CConvert()
        # #
        # ThreadValues = THR.CThread('TV', UartOnReadData)
        # ThreadValues.Start()    
        # #
    MainWindow = FM.CFrameMain(TKI.Tk(), PERIOD_REFRESHPLOT, \
                               TIME_START, TIME_PERIOD, \
                               -AMPLITUDE_FIXED, +AMPLITUDE_FIXED)
        # MainWindow.Plot.SetOnRefreshValues(OnRefreshValues)
    MainWindow.Execute();
        # #
        # ThreadValues.Abort()
        # ThreadValues.WaitForEnd()
        #
    #finally:
    #    UartEsp32.Close()
    #
    print('*** PcLRSMeasurement: end')
    #
#

