//
#include "RxFrameLRS.h"
//
CRxFrameLRS::CRxFrameLRS(void)
{
  FOnTransmitLine = 0;
  Initialise();  
}
//
void CRxFrameLRS::SetOnTransmitLine(CBOnTransmitLine value)
{
  FOnTransmitLine = value;
}
//
void CRxFrameLRS::Initialise(void)
{
  memset(NAME, BZERO, RXFRAMELRS_SIZE_NAME);
  memset(DATE, BZERO, RXFRAMELRS_SIZE_DATE);
  memset(TIME, BZERO, RXFRAMELRS_SIZE_TIME);
  CYCLECOUNT = IZERO;
  ANGLEZENITH = FZERO;
  TIMECYCLE = IZERO;
  TCOLD = FZERO;
  THOT = FZERO;
  for (int I = 0; I < RXFRAMELRS_SIZE_FILTER; I++)
  {
    FIC[I] = IZERO;
    FIH[I] = IZERO;
    FIA[I] = IZERO;
  }
  for (int I = 0; I < RXFRAMELRS_SIZE_HOUSEKEEPING; I++)
  {
    HKC[I] = IZERO;
    HKH[I] = IZERO;
    HKA[I] = IZERO;
  }  
}

void CRxFrameLRS::TransmitData(void)
{
  sprintf(FBuffer, "%-8.8s %-6.6s %-6.6s %u %+5.1f %u %+5.1f %+5.1f",
          NAME, DATE, TIME, CYCLECOUNT, ANGLEZENITH, TIMECYCLE, TCOLD, THOT);
  FOnTransmitLine(FBuffer);
  for (int RI = 0; RI < 32; RI += 8)
  {
    sprintf(FBuffer, "%+5.5i %+5.5i %+5.5i %+5.5i %+5.5i %+5.5i %+5.5i %+5.5i",
                    FIC[0 + RI], FIC[1 + RI], FIC[2 + RI], FIC[3 + RI],
                    FIC[4 + RI], FIC[5 + RI], FIC[6 + RI], FIC[7 + RI]);
    FOnTransmitLine(FBuffer);
  }
  for (int RI = 0; RI < 32; RI += 8)
  {
    sprintf(FBuffer, "%+5.5i %+5.5i %+5.5i %+5.5i %+5.5i %+5.5i %+5.5i %+5.5i",
                    FIH[0 + RI], FIH[1 + RI], FIH[2 + RI], FIH[3 + RI],
                    FIH[4 + RI], FIH[5 + RI], FIH[6 + RI], FIH[7 + RI]);
    FOnTransmitLine(FBuffer);
  }
  for (int RI = 0; RI < 32; RI += 8)
  {
    sprintf(FBuffer, "%+5.5i %+5.5i %+5.5i %+5.5i %+5.5i %+5.5i %+5.5i %+5.5i",
                    FIA[0 + RI], FIA[1 + RI], FIA[2 + RI], FIA[3 + RI],
                    FIA[4 + RI], FIA[5 + RI], FIA[6 + RI], FIA[7 + RI]);
    FOnTransmitLine(FBuffer);
  }
  sprintf(FBuffer, "%+5.5i %+5.5i %+5.5i %+5.5i %+5.5i %+5.5i %+5.5i %+5.5i",
                  HKC[0], HKC[1], HKC[2], HKC[3], HKC[4], HKC[5], HKC[6], HKC[7]);
  FOnTransmitLine(FBuffer);
  sprintf(FBuffer, "%+5.5i %+5.5i %+5.5i %+5.5i %+5.5i %+5.5i %+5.5i %+5.5i",
                  HKH[0], HKH[1], HKH[2], HKH[3], HKH[4], HKH[5], HKH[6], HKH[7]);
  FOnTransmitLine(FBuffer);
  sprintf(FBuffer, "%+5.5i %+5.5i %+5.5i %+5.5i %+5.5i %+5.5i %+5.5i %+5.5i",
                  HKA[0], HKA[1], HKA[2], HKA[3], HKA[4], HKA[5], HKA[6], HKA[7]);
  FOnTransmitLine(FBuffer);
}


//
void CRxFrameLRS::InitialiseBackgroundNoise(CPCharacter name, 
                                            CPCharacter date, CPCharacter time,
                                            Float32 anglezenith, Int32 timecycle,
                                            Float32 tcold, Float32 thot)
{
  sprintf(NAME, FORMAT_NAME, name);
  sprintf(DATE, FORMAT_DATE, date);
  sprintf(TIME, FORMAT_TIME, time);
  CYCLECOUNT = IZERO;
  ANGLEZENITH = anglezenith;
  TIMECYCLE = timecycle;
  TCOLD = tcold;
  THOT = thot;
  FMillisPreset = millis();
}
void CRxFrameLRS::ExecuteBackgroundNoise(void)
{
  if (TIMECYCLE < (millis() - FMillisPreset))
  {
    FMillisPreset = millis();
    CYCLECOUNT++;
    if (0 < FOnTransmitLine)
    { //  generate values
      for (int I = 0; I < 32; I++)
      {
        FIC[I] = random(FILTER_MINIMUM, FILTER_MAXIMUM);
        FIH[I] = random(FILTER_MINIMUM, FILTER_MAXIMUM);
        FIA[I] = random(FILTER_MINIMUM, FILTER_MAXIMUM);
      }
      for (int I = 0; I < 8; I++)
      {
        HKC[I] = random(HOUSEKEEPING_MINIMUM, HOUSEKEEPING_MAXIMUM);
        HKH[I] = random(HOUSEKEEPING_MINIMUM, HOUSEKEEPING_MAXIMUM);
        HKA[I] = random(HOUSEKEEPING_MINIMUM, HOUSEKEEPING_MAXIMUM);
      }
      TransmitData();
    }  
  }
}
//
void CRxFrameLRS::InitialiseSawtoothNoise(CPCharacter name, 
                                          CPCharacter date, CPCharacter time,
                                          Float32 anglezenith, Int32 timecycle, 
                                          Float32 tcold, Float32 thot)
{
  sprintf(NAME, FORMAT_NAME, name);
  sprintf(DATE, FORMAT_DATE, date);
  sprintf(TIME, FORMAT_TIME, time);
  CYCLECOUNT = IZERO;
  ANGLEZENITH = anglezenith;
  TIMECYCLE = timecycle;
  TCOLD = tcold;
  THOT = thot;
  STNIsRising = true;
  STNMinimum = -100;
  STNMaximum = +100;
  STNAnoise = 5.0f;
  STNFilter = -10;
  FMillisPreset = millis();
}
void CRxFrameLRS::ExecuteSawtoothNoise(void)
{
  if (TIMECYCLE < (millis() - FMillisPreset))
  {
    FMillisPreset = millis();
    CYCLECOUNT++;

    if (STNIsRising)
    {
      STNFilter += 10;
    }
    else
    {
      STNFilter -= 10;
    }
    if (STNFilter < STNMinimum)
    {
      STNFilter = STNMinimum;
      STNIsRising = true;
    }
    else
    if (STNMaximum < STNFilter)
    {
      STNFilter = STNMaximum;
      STNIsRising = false;
    }
    if (0 < FOnTransmitLine)
    { //  generate values
      for (int I = 0; I < 32; I++)
      {
        FIC[I] = STNFilter + STNAnoise * 0.001 * random(-1000, 1001);
        FIH[I] = STNFilter + STNAnoise * 0.001 * random(-1000, 1001);
        FIA[I] = STNFilter + STNAnoise * 0.001 * random(-1000, 1001);
      }
      for (int I = 0; I < 8; I++)
      {
        HKC[I] = STNFilter + STNAnoise * 0.001 * random(-1000, 1001);
        HKH[I] = STNFilter + STNAnoise * 0.001 * random(-1000, 1001);
        HKA[I] = STNFilter + STNAnoise * 0.001 * random(-1000, 1001);
      }      
      TransmitData();
    }
  }  
}


//
void CRxFrameLRS::InitialiseSinusNoise(CPCharacter name, 
                                      CPCharacter date, CPCharacter time,
                                      Float32 anglezenith, Int32 timecycle, 
                                      Float32 tcold, Float32 thot)
{
  sprintf(NAME, FORMAT_NAME, name);
  sprintf(DATE, FORMAT_DATE, date);
  sprintf(TIME, FORMAT_TIME, time);
  CYCLECOUNT = IZERO;
  ANGLEZENITH = anglezenith;
  TIMECYCLE = timecycle;
  TCOLD = tcold;
  THOT = thot;
  SNAmplitudeSinus = +100.0f;
  SNAmplitudeNoise = +5.0f;
  SNTime = 0.0f;  // [ms]
  SNPeriod = 30000.0f; // [ms]
  FMillisPreset = millis();
}
void CRxFrameLRS::ExecuteSinusNoise(void)
{
   if (TIMECYCLE < (millis() - FMillisPreset))
  {
    FMillisPreset = millis();
    CYCLECOUNT++;
    //    
    if (0 < FOnTransmitLine)
    { //  generate values
      SNTime += 1000.0;
      for (int I = 0; I < 32; I++)
      {
        FIC[I] = -20.0 + SNAmplitudeSinus * sin(PID * SNTime / SNPeriod) + 
                 SNAmplitudeNoise * 0.001 * random(-1000, 1001);
        FIH[I] = +20.0 + SNAmplitudeSinus * sin(PID * SNTime / SNPeriod) + 
                 SNAmplitudeNoise * 0.001 * random(-1000, 1001);
        FIA[I] = SNAmplitudeSinus * sin(PID * SNTime / SNPeriod) + 
                 SNAmplitudeNoise * 0.001 * random(-1000, 1001);
      }
      for (int I = 0; I < 8; I++)
      {
        HKC[I] = -50 + SNAmplitudeSinus * sin(PID * SNTime / SNPeriod) + 
                 SNAmplitudeNoise * 0.001 * random(-1000, 1001);
        HKH[I] = -30 + SNAmplitudeSinus * sin(PID * SNTime / SNPeriod) + 
                 SNAmplitudeNoise * 0.001 * random(-1000, 1001);
        HKA[I] = -40 + SNAmplitudeSinus * sin(PID * SNTime / SNPeriod) + 
                 SNAmplitudeNoise * 0.001 * random(-1000, 1001);
      }      
      TransmitData();
    }
  }  
}
//
void CRxFrameLRS::InitialiseMeasurement(CPCharacter name, 
                                        CPCharacter date, CPCharacter time,
                                        Float32 anglezenith, Int32 timecycle, 
                                        Float32 tcold, Float32 thot)
{
}
void CRxFrameLRS::ExecuteMeasurement(void)
{
  if (TIMECYCLE < (millis() - FMillisPreset))
  {
    FMillisPreset = millis();
    CYCLECOUNT++;
  }  
}
//
void CRxFrameLRS::InitialisePassThrough(CPCharacter name, 
                                        CPCharacter date, CPCharacter time,
                                        Float32 anglezenith, Int32 timecycle, 
                                        Float32 tcold, Float32 thot)
{
}
void CRxFrameLRS::ExecutePassThrough(void)
{
  if (TIMECYCLE < (millis() - FMillisPreset))
  {
    FMillisPreset = millis();
    CYCLECOUNT++;
  }  
}
//
//