//
//-------------------------------------------------
//  RxFrameData
//-------------------------------------------------
// generating LRSFrameData 
// no Uart, only Debug-Refrences
// only building of text
//
//
#pragma once
//
#include "Define.h"
//
#ifndef RxFrameLRS_h
#define RxFrameLRS_h
//
#include <stdio.h>
#include <string.h>
#include <cstring>
#include "Constant.h"
//
//-------------------------------------------------
const int RXFRAMELRS_SIZE_BUFFER        = 128;
const int RXFRAMELRS_SIZE_NAME          = 1 + 8;
const int RXFRAMELRS_SIZE_DATE          = 1 + 6;
const int RXFRAMELRS_SIZE_TIME          = 1 + 6;
const int RXFRAMELRS_SIZE_FILTER        = 32;
const int RXFRAMELRS_SIZE_HOUSEKEEPING  = 8;
//
typedef void (*CBOnTransmitLine)(PCharacter line);
//
//-------------------------------------------------
class CRxFrameLRS
{
  private:
  const char* FORMAT_NAME = "%-8.8s";
  const char* FORMAT_DATE = "%-6.6s";
  const char* FORMAT_TIME = "%-6.6s";
  //
  const Int32 FILTER_MINIMUM = -9999;
  const Int32 FILTER_MAXIMUM = 1 + 9999;
  const Int32 HOUSEKEEPING_MINIMUM = -49999;
  const Int32 HOUSEKEEPING_MAXIMUM = 1 + 49999;
  //
  Character NAME[RXFRAMELRS_SIZE_NAME];       // [string]
  Character DATE[RXFRAMELRS_SIZE_DATE];       // [string]
  Character TIME[RXFRAMELRS_SIZE_TIME];       // [string]
  Int32     CYCLECOUNT;                       // [1]
  Float32   ANGLEZENITH;                      // [deg]
  Int32     TIMECYCLE;                        // [ms]
  Float32   TCOLD;                            // [K]
  Float32   THOT;                             // [K]
  Int32     FIC[RXFRAMELRS_SIZE_FILTER];      // [1] ???
  Int32     FIH[RXFRAMELRS_SIZE_FILTER];      // [1] ???
  Int32     FIA[RXFRAMELRS_SIZE_FILTER];      // [1] ???
  Int32     HKC[RXFRAMELRS_SIZE_HOUSEKEEPING];// [1] ???
  Int32     HKH[RXFRAMELRS_SIZE_HOUSEKEEPING];// [1] ???
  Int32     HKA[RXFRAMELRS_SIZE_HOUSEKEEPING];// [1] ???
  //
  Character FBuffer[RXFRAMELRS_SIZE_BUFFER];
  CBOnTransmitLine FOnTransmitLine;
  UInt32 FMillisPreset;
  // Sawtooth
  Boolean STNIsRising;
  Int32 STNMinimum;
  Int32 STNMaximum;
  Float32 STNAnoise;
  Int32 STNFilter;
  // Sinus
  Float32 SNAmplitudeSinus;
  Float32 SNAmplitudeNoise;
  Float32 SNTime; // [ms]
  Float32 SNPeriod; // [ms]
  //
  public:
  CRxFrameLRS(void);
  //
  void SetOnTransmitLine(CBOnTransmitLine value);
  void Initialise(void);
  void TransmitData(void);
  //
  void InitialiseBackgroundNoise(CPCharacter name, 
                        CPCharacter date, CPCharacter time,
                        Float32 anglezenith, Int32 timecycle, 
                        Float32 tcold, Float32 thot);
  void ExecuteBackgroundNoise(void);
  //
  void InitialiseSawtoothNoise(CPCharacter name, 
                               CPCharacter date, CPCharacter time,
                               Float32 anglezenith, Int32 timecycle, 
                               Float32 tcold, Float32 thot);
  void ExecuteSawtoothNoise(void);
  //
  void InitialiseSinusNoise(CPCharacter name, 
                            CPCharacter date, CPCharacter time,
                            Float32 anglezenith, Int32 timecycle, 
                            Float32 tcold, Float32 thot);
  void ExecuteSinusNoise(void);
  //
  void InitialiseMeasurement(CPCharacter name, 
                             CPCharacter date, CPCharacter time,
                             Float32 anglezenith, Int32 timecycle, 
                             Float32 tcold, Float32 thot);
  void ExecuteMeasurement(void);
  //
  void InitialisePassThrough(CPCharacter name, 
                             CPCharacter date, CPCharacter time,
                             Float32 anglezenith, Int32 timecycle, 
                             Float32 tcold, Float32 thot);
  void ExecutePassThrough(void);
};

//
//-------------------------------------------------
//
//-------------------------------------------------


//
//-------------------------------------------------
//
//-------------------------------------------------
#endif // RxFrameData_h
