#
#----------------------------------------------------------------------
#   FrameValues
#----------------------------------------------------------------------
import random as RND
import numpy as NP
import matplotlib.pyplot as PLT
import tkinter as TKI
from matplotlib.backends.backend_tkagg \
    import FigureCanvasTkAgg #, NavigationToolbar2Tk
#
BX = 6
BY = 10
SX = 100
SXF = 60
SY = 20
WLBL = 10
CFG = '#000000'
CBGH = '#FFEEDD'
CBGV = '#EEFFDD'
#
#----------------------------------------------------------------------
class CFrameValues():
    #
    def __init__(self, parent):
        self.Parent = parent
        #
        #self.Parent.rowconfigure(index=0, weight=1)
        # self.Parent.rowconfigure(index=1, weight=1) # 1 Plot!
        # self.Parent.rowconfigure(index=2, weight=1)
        # self.Parent.rowconfigure(index=3, weight=1)
        # self.Parent.rowconfigure(index=4, weight=1)
        # self.Parent.rowconfigure(index=5, weight=1)
        # self.Parent.columnconfigure(index=0, weight=1) # 1 Plot!
        # self.Parent.columnconfigure(index=1, weight=1) # 1 Plot!
        # self.Parent.columnconfigure(index=2, weight=1) # 1 Plot!        
        # self.Parent.columnconfigure(index=3, weight=1) # 1 Plot!        
        # self.Parent.columnconfigure(index=4, weight=1) # 1 Plot!        
        # self.Parent.columnconfigure(index=5, weight=1) # 1 Plot!        
        #
        # GPS
        #--------------------------------------------------------------------
        self.lblGPSTitle = TKI.Label(self.Parent, bg='#E7E7FF', \
                                    text='Data GPS - GlobalPositioningSystem')
        self.lblGPSTitle.place(x=1*BX+0*SX, y=1*BY+0*SY, w=11*SX, h=SY)
        #
        self.lblGPSDateN = TKI.Label(self.Parent, bg=CBGH, text='Date')
        self.lblGPSDateN.place(x=1*BX+0*SX, y=2*BY+1*SY, w=SX, h=SY)
        self.lblGPSDateV = TKI.Label(self.Parent, bg=CBGV, text='0')
        self.lblGPSDateV.place(x=2*BX+1*SX, y=2*BY+1*SY, w=SX, h=SY)
        #
        self.lblGPSTimeN = TKI.Label(self.Parent, text='Time', bg=CBGH)
        self.lblGPSTimeN.place(x=3*BX+2*SX, y=2*BY+1*SY, w=SX, h=SY)
        self.lblGPSTimeV = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblGPSTimeV.place(x=4*BX+3*SX, y=2*BY+1*SY, w=SX, h=SY)
        #
        #--------------------------------------------------------------------
        self.lblGPSLatitudeN = TKI.Label(self.Parent, text='Latitude', bg=CBGH)
        self.lblGPSLatitudeN.place(x=1*BX+0*SX, y=3*BY+2*SY, w=SX, h=SY)
        self.lblGPSLatitudeV = TKI.Label(self.Parent, text='0.0', bg=CBGV)
        self.lblGPSLatitudeV.place(x=2*BX+1*SX, y=3*BY+2*SY, w=SX, h=SY)
        self.lblGPSLatitudeU = TKI.Label(self.Parent, text='deg', bg=CBGH)
        self.lblGPSLatitudeU.place(x=3*BX+2*SX, y=3*BY+2*SY, w=SX, h=SY)
        #
        self.lblGPSLongitudeN = TKI.Label(self.Parent, text='Longitude', bg=CBGH)
        self.lblGPSLongitudeN.place(x=4*BX+3*SX, y=3*BY+2*SY, w=SX, h=SY)
        self.lblGPSLongitudeV = TKI.Label(self.Parent, text='0.0', bg=CBGV)
        self.lblGPSLongitudeV.place(x=5*BX+4*SX, y=3*BY+2*SY, w=SX, h=SY)
        self.lblGPSLongitudeU = TKI.Label(self.Parent, text='deg', bg=CBGH)
        self.lblGPSLongitudeU.place(x=6*BX+5*SX, y=3*BY+2*SY, w=SX, h=SY)
        #
        self.lblGPSAltitudeN = TKI.Label(self.Parent, text='Altitude', bg=CBGH)
        self.lblGPSAltitudeN.place(x=7*BX+6*SX, y=3*BY+2*SY, w=SX, h=SY)
        self.lblGPSAltitudeV = TKI.Label(self.Parent, text='0.0', bg=CBGV)
        self.lblGPSAltitudeV.place(x=8*BX+7*SX, y=3*BY+2*SY, w=SX, h=SY)
        self.lblGPSAltitudeU = TKI.Label(self.Parent, text='m', bg=CBGH)
        self.lblGPSAltitudeU.place(x=9*BX+8*SX, y=3*BY+2*SY, w=SX, h=SY)        
        #
        #--------------------------------------------------------------------
        self.lblGPSSatellitesN = TKI.Label(self.Parent, text='Satellites', bg=CBGH)
        self.lblGPSSatellitesN.place(x=1*BX+0*SX, y=4*BY+3*SY, w=SX, h=SY)
        self.lblGPSSatellitesV = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblGPSSatellitesV.place(x=2*BX+1*SX, y=4*BY+3*SY, w=SX, h=SY)
        #
        self.lblGPSPrecisionN = TKI.Label(self.Parent, text='Precision', bg=CBGH)
        self.lblGPSPrecisionN.place(x=3*BX+2*SX, y=4*BY+3*SY, w=SX, h=SY)
        self.lblGPSPrecisionV = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblGPSPrecisionV.place(x=4*BX+3*SX, y=4*BY+3*SY, w=SX, h=SY)
        #
        self.lblGPSCharactersN = TKI.Label(self.Parent, text='Characters', bg=CBGH)
        self.lblGPSCharactersN.place(x=5*BX+4*SX, y=4*BY+3*SY, w=SX, h=SY)
        self.lblGPSCharactersV = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblGPSCharactersV.place(x=6*BX+5*SX, y=4*BY+3*SY, w=SX, h=SY)
        #
        self.lblGPSGoodN = TKI.Label(self.Parent, text='Goods', bg=CBGH)
        self.lblGPSGoodN.place(x=7*BX+6*SX, y=4*BY+3*SY, w=SX, h=SY)
        self.lblGPSGoodV = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblGPSGoodV.place(x=8*BX+7*SX, y=4*BY+3*SY, w=SX, h=SY)
        #
        self.lblGPSErrorsN = TKI.Label(self.Parent, text='Errors', bg=CBGH)
        self.lblGPSErrorsN.place(x=9*BX+8*SX, y=4*BY+3*SY, w=SX, h=SY)
        self.lblGPSErrorsV = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblGPSErrorsV.place(x=10*BX+9*SX, y=4*BY+3*SY, w=SX, h=SY)
        #
        # LRS
        #--------------------------------------------------------------------
        self.lblLRSTitle = TKI.Label(self.Parent, bg='#E7E7FF', \
                                    text='Data LRS - LoidlRadioSpectrometer')
        self.lblLRSTitle.place(x=1*BX+0*SX, y=5*BY+4*SY, w=11*SX, h=SY)
        #--------------------------------------------------------------------
        # 1.row
        self.lblLRSNameN = TKI.Label(self.Parent, bg=CBGH, text='Date')
        self.lblLRSNameN.place(x=1*BX+0*SX, y=6*BY+5*SY, w=SX, h=SY)
        self.lblLRSNameV = TKI.Label(self.Parent, bg=CBGV, text='0')
        self.lblLRSNameV.place(x=2*BX+1*SX, y=6*BY+5*SY, w=SX, h=SY)
        #
        self.lblLRSDateN = TKI.Label(self.Parent, bg=CBGH, text='Date')
        self.lblLRSDateN.place(x=3*BX+2*SX, y=6*BY+5*SY, w=SX, h=SY)
        self.lblLRSDateV = TKI.Label(self.Parent, bg=CBGV, text='0')
        self.lblLRSDateV.place(x=4*BX+3*SX, y=6*BY+5*SY, w=SX, h=SY)
        #
        self.lblLRSTimeN = TKI.Label(self.Parent, bg=CBGH, text='Time')
        self.lblLRSTimeN.place(x=5*BX+4*SX, y=6*BY+5*SY, w=SX, h=SY)
        self.lblLRSTimeV = TKI.Label(self.Parent, bg=CBGV, text='0')
        self.lblLRSTimeV.place(x=6*BX+5*SX, y=6*BY+5*SY, w=SX, h=SY)
        #
        self.lblLRSCycleCountN = TKI.Label(self.Parent, bg=CBGH, text='CycleCount')
        self.lblLRSCycleCountN.place(x=7*BX+6*SX, y=6*BY+5*SY, w=SX, h=SY)
        self.lblLRSCycleCountV = TKI.Label(self.Parent, bg=CBGV, text='0')
        self.lblLRSCycleCountV.place(x=8*BX+7*SX, y=6*BY+5*SY, w=SX, h=SY)
        #--------------------------------------------------------------------
        # 2.row
        self.lblLRSZenithAngleN = TKI.Label(self.Parent, text='ZenithAngle', bg=CBGH)
        self.lblLRSZenithAngleN.place(x=1*BX+0*SX, y=7*BY+6*SY, w=SX, h=SY)
        self.lblLRSZenithAngleV = TKI.Label(self.Parent, text='0.0', bg=CBGV)
        self.lblLRSZenithAngleV.place(x=2*BX+1*SX, y=7*BY+6*SY, w=SX, h=SY)
        self.lblLRSZenithAngleU = TKI.Label(self.Parent, text='deg', bg=CBGH)
        self.lblLRSZenithAngleU.place(x=3*BX+2*SX, y=7*BY+6*SY, w=SX, h=SY)        
        #
        self.lblLRSCycleTimeN = TKI.Label(self.Parent, text='CycleTime', bg=CBGH)
        self.lblLRSCycleTimeN.place(x=4*BX+3*SX, y=7*BY+6*SY, w=SX, h=SY)
        self.lblLRSCycleTimeV = TKI.Label(self.Parent, text='0.0', bg=CBGV)
        self.lblLRSCycleTimeV.place(x=5*BX+4*SX, y=7*BY+6*SY, w=SX, h=SY)
        self.lblLRSCycleTimeU = TKI.Label(self.Parent, text='ms', bg=CBGH)
        self.lblLRSCycleTimeU.place(x=6*BX+5*SX, y=7*BY+6*SY, w=SX, h=SY)
        #--------------------------------------------------------------------
        # 3.row - FI00C - FI08C
        self.lblLRSFIC00N = TKI.Label(self.Parent, text='FI00C', bg=CBGH)
        self.lblLRSFIC00N.place(x=1*BX+0*SXF, y=8*BY+7*SY, w=SXF, h=SY)
        self.lblLRSFIC00V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC00V.place(x=2*BX+1*SXF, y=8*BY+7*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC01N = TKI.Label(self.Parent, text='FI01C', bg=CBGH)
        self.lblLRSFIC01N.place(x=3*BX+2*SXF, y=8*BY+7*SY, w=SXF, h=SY)
        self.lblLRSFIC01V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC01V.place(x=4*BX+3*SXF, y=8*BY+7*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC02N = TKI.Label(self.Parent, text='FI02C', bg=CBGH)
        self.lblLRSFIC02N.place(x=5*BX+4*SXF, y=8*BY+7*SY, w=SXF, h=SY)
        self.lblLRSFIC02V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC02V.place(x=6*BX+5*SXF, y=8*BY+7*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC03N = TKI.Label(self.Parent, text='FI03C', bg=CBGH)
        self.lblLRSFIC03N.place(x=7*BX+6*SXF, y=8*BY+7*SY, w=SXF, h=SY)
        self.lblLRSFIC03V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC03V.place(x=8*BX+7*SXF, y=8*BY+7*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC04N = TKI.Label(self.Parent, text='FI04C', bg=CBGH)
        self.lblLRSFIC04N.place(x=9*BX+8*SXF, y=8*BY+7*SY, w=SXF, h=SY)
        self.lblLRSFIC04V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC04V.place(x=10*BX+9*SXF, y=8*BY+7*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC05N = TKI.Label(self.Parent, text='FI05C', bg=CBGH)
        self.lblLRSFIC05N.place(x=11*BX+10*SXF, y=8*BY+7*SY, w=SXF, h=SY)
        self.lblLRSFIC05V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC05V.place(x=12*BX+11*SXF, y=8*BY+7*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC06N = TKI.Label(self.Parent, text='FI06C', bg=CBGH)
        self.lblLRSFIC06N.place(x=13*BX+12*SXF, y=8*BY+7*SY, w=SXF, h=SY)
        self.lblLRSFIC06V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC06V.place(x=14*BX+13*SXF, y=8*BY+7*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC07N = TKI.Label(self.Parent, text='FI07C', bg=CBGH)
        self.lblLRSFIC07N.place(x=15*BX+14*SXF, y=8*BY+7*SY, w=SXF, h=SY)
        self.lblLRSFIC07V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC07V.place(x=16*BX+15*SXF, y=8*BY+7*SY, w=SXF, h=SY)
        #--------------------------------------------------------------------
        # 4.row - FI08C - FI15C
        self.lblLRSFIC08N = TKI.Label(self.Parent, text='FI08C', bg=CBGH)
        self.lblLRSFIC08N.place(x=1*BX+0*SXF, y=9*BY+8*SY, w=SXF, h=SY)
        self.lblLRSFIC08V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC08V.place(x=2*BX+1*SXF, y=9*BY+8*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC09N = TKI.Label(self.Parent, text='FI09C', bg=CBGH)
        self.lblLRSFIC09N.place(x=3*BX+2*SXF, y=9*BY+8*SY, w=SXF, h=SY)
        self.lblLRSFIC09V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC09V.place(x=4*BX+3*SXF, y=9*BY+8*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC10N = TKI.Label(self.Parent, text='FI10C', bg=CBGH)
        self.lblLRSFIC10N.place(x=5*BX+4*SXF, y=9*BY+8*SY, w=SXF, h=SY)
        self.lblLRSFIC10V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC10V.place(x=6*BX+5*SXF, y=9*BY+8*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC11N = TKI.Label(self.Parent, text='FI11C', bg=CBGH)
        self.lblLRSFIC11N.place(x=7*BX+6*SXF, y=9*BY+8*SY, w=SXF, h=SY)
        self.lblLRSFIC11V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC11V.place(x=8*BX+7*SXF, y=9*BY+8*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC12N = TKI.Label(self.Parent, text='FI12C', bg=CBGH)
        self.lblLRSFIC12N.place(x=9*BX+8*SXF, y=9*BY+8*SY, w=SXF, h=SY)
        self.lblLRSFIC12V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC12V.place(x=10*BX+9*SXF, y=9*BY+8*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC13N = TKI.Label(self.Parent, text='FI13C', bg=CBGH)
        self.lblLRSFIC13N.place(x=11*BX+10*SXF, y=9*BY+8*SY, w=SXF, h=SY)
        self.lblLRSFIC13V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC13V.place(x=12*BX+11*SXF, y=9*BY+8*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC14N = TKI.Label(self.Parent, text='FI14C', bg=CBGH)
        self.lblLRSFIC14N.place(x=13*BX+12*SXF, y=9*BY+8*SY, w=SXF, h=SY)
        self.lblLRSFIC14V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC14V.place(x=14*BX+13*SXF, y=9*BY+8*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC15N = TKI.Label(self.Parent, text='FI15C', bg=CBGH)
        self.lblLRSFIC15N.place(x=15*BX+14*SXF, y=9*BY+8*SY, w=SXF, h=SY)
        self.lblLRSFIC15V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC15V.place(x=16*BX+15*SXF, y=9*BY+8*SY, w=SXF, h=SY)
        #--------------------------------------------------------------------
        # 4.row - FI16C - FI23C
        self.lblLRSFIC16N = TKI.Label(self.Parent, text='FI16C', bg=CBGH)
        self.lblLRSFIC16N.place(x=1*BX+0*SXF, y=10*BY+9*SY, w=SXF, h=SY)
        self.lblLRSFIC16V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC16V.place(x=2*BX+1*SXF, y=10*BY+9*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC17N = TKI.Label(self.Parent, text='FI17C', bg=CBGH)
        self.lblLRSFIC17N.place(x=3*BX+2*SXF, y=10*BY+9*SY, w=SXF, h=SY)
        self.lblLRSFIC17V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC17V.place(x=4*BX+3*SXF, y=10*BY+9*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC18N = TKI.Label(self.Parent, text='FI18C', bg=CBGH)
        self.lblLRSFIC18N.place(x=5*BX+4*SXF, y=10*BY+9*SY, w=SXF, h=SY)
        self.lblLRSFIC18V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC18V.place(x=6*BX+5*SXF, y=10*BY+9*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC19N = TKI.Label(self.Parent, text='FI19C', bg=CBGH)
        self.lblLRSFIC19N.place(x=7*BX+6*SXF, y=10*BY+9*SY, w=SXF, h=SY)
        self.lblLRSFIC19V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC19V.place(x=8*BX+7*SXF, y=10*BY+9*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC20N = TKI.Label(self.Parent, text='FI20C', bg=CBGH)
        self.lblLRSFIC20N.place(x=9*BX+8*SXF, y=10*BY+9*SY, w=SXF, h=SY)
        self.lblLRSFIC20V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC20V.place(x=10*BX+9*SXF, y=10*BY+9*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC21N = TKI.Label(self.Parent, text='FI21C', bg=CBGH)
        self.lblLRSFIC21N.place(x=11*BX+10*SXF, y=10*BY+9*SY, w=SXF, h=SY)
        self.lblLRSFIC21V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC21V.place(x=12*BX+11*SXF, y=10*BY+9*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC22N = TKI.Label(self.Parent, text='FI22C', bg=CBGH)
        self.lblLRSFIC22N.place(x=13*BX+12*SXF, y=10*BY+9*SY, w=SXF, h=SY)
        self.lblLRSFIC22V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC22V.place(x=14*BX+13*SXF, y=10*BY+9*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC23N = TKI.Label(self.Parent, text='FI23C', bg=CBGH)
        self.lblLRSFIC23N.place(x=15*BX+14*SXF, y=10*BY+9*SY, w=SXF, h=SY)
        self.lblLRSFIC23V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC23V.place(x=16*BX+15*SXF, y=10*BY+9*SY, w=SXF, h=SY)
        #--------------------------------------------------------------------
        # 5.row - FI24C - FI31C
        self.lblLRSFIC24N = TKI.Label(self.Parent, text='FI24C', bg=CBGH)
        self.lblLRSFIC24N.place(x=1*BX+0*SXF, y=11*BY+10*SY, w=SXF, h=SY)
        self.lblLRSFIC24V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC24V.place(x=2*BX+1*SXF, y=11*BY+10*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC25N = TKI.Label(self.Parent, text='FI25C', bg=CBGH)
        self.lblLRSFIC25N.place(x=3*BX+2*SXF, y=11*BY+10*SY, w=SXF, h=SY)
        self.lblLRSFIC25V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC25V.place(x=4*BX+3*SXF, y=11*BY+10*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC26N = TKI.Label(self.Parent, text='FI26C', bg=CBGH)
        self.lblLRSFIC26N.place(x=5*BX+4*SXF, y=11*BY+10*SY, w=SXF, h=SY)
        self.lblLRSFIC26V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC26V.place(x=6*BX+5*SXF, y=11*BY+10*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC27N = TKI.Label(self.Parent, text='FI27C', bg=CBGH)
        self.lblLRSFIC27N.place(x=7*BX+6*SXF, y=11*BY+10*SY, w=SXF, h=SY)
        self.lblLRSFIC27V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC27V.place(x=8*BX+7*SXF, y=11*BY+10*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC28N = TKI.Label(self.Parent, text='FI28C', bg=CBGH)
        self.lblLRSFIC28N.place(x=9*BX+8*SXF, y=11*BY+10*SY, w=SXF, h=SY)
        self.lblLRSFIC28V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC28V.place(x=10*BX+9*SXF, y=11*BY+10*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC29N = TKI.Label(self.Parent, text='FI29C', bg=CBGH)
        self.lblLRSFIC29N.place(x=11*BX+10*SXF, y=11*BY+10*SY, w=SXF, h=SY)
        self.lblLRSFIC29V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC29V.place(x=12*BX+11*SXF, y=11*BY+10*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC30N = TKI.Label(self.Parent, text='FI30C', bg=CBGH)
        self.lblLRSFIC30N.place(x=13*BX+12*SXF, y=11*BY+10*SY, w=SXF, h=SY)
        self.lblLRSFIC30V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC30V.place(x=14*BX+13*SXF, y=11*BY+10*SY, w=SXF, h=SY)
        #
        self.lblLRSFIC31N = TKI.Label(self.Parent, text='FI31C', bg=CBGH)
        self.lblLRSFIC31N.place(x=15*BX+14*SXF, y=11*BY+10*SY, w=SXF, h=SY)
        self.lblLRSFIC31V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIC31V.place(x=16*BX+15*SXF, y=11*BY+10*SY, w=SXF, h=SY)
        #--------------------------------------------------------------------
        # 6.row - FI00H - FI08H
        self.lblLRSFIH00N = TKI.Label(self.Parent, text='FI00H', bg=CBGH)
        self.lblLRSFIH00N.place(x=1*BX+0*SXF, y=12*BY+11*SY, w=SXF, h=SY)
        self.lblLRSFIH00V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH00V.place(x=2*BX+1*SXF, y=12*BY+11*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH01N = TKI.Label(self.Parent, text='FI01H', bg=CBGH)
        self.lblLRSFIH01N.place(x=3*BX+2*SXF, y=12*BY+11*SY, w=SXF, h=SY)
        self.lblLRSFIH01V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH01V.place(x=4*BX+3*SXF, y=12*BY+11*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH02N = TKI.Label(self.Parent, text='FI02H', bg=CBGH)
        self.lblLRSFIH02N.place(x=5*BX+4*SXF, y=12*BY+11*SY, w=SXF, h=SY)
        self.lblLRSFIH02V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH02V.place(x=6*BX+5*SXF, y=12*BY+11*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH03N = TKI.Label(self.Parent, text='FI03H', bg=CBGH)
        self.lblLRSFIH03N.place(x=7*BX+6*SXF, y=12*BY+11*SY, w=SXF, h=SY)
        self.lblLRSFIH03V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH03V.place(x=8*BX+7*SXF, y=12*BY+11*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH04N = TKI.Label(self.Parent, text='FI04H', bg=CBGH)
        self.lblLRSFIH04N.place(x=9*BX+8*SXF, y=12*BY+11*SY, w=SXF, h=SY)
        self.lblLRSFIH04V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH04V.place(x=10*BX+9*SXF, y=12*BY+11*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH05N = TKI.Label(self.Parent, text='FI05H', bg=CBGH)
        self.lblLRSFIH05N.place(x=11*BX+10*SXF, y=12*BY+11*SY, w=SXF, h=SY)
        self.lblLRSFIH05V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH05V.place(x=12*BX+11*SXF, y=12*BY+11*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH06N = TKI.Label(self.Parent, text='FI06H', bg=CBGH)
        self.lblLRSFIH06N.place(x=13*BX+12*SXF, y=12*BY+11*SY, w=SXF, h=SY)
        self.lblLRSFIH06V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH06V.place(x=14*BX+13*SXF, y=12*BY+11*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH07N = TKI.Label(self.Parent, text='FI07H', bg=CBGH)
        self.lblLRSFIH07N.place(x=15*BX+14*SXF, y=12*BY+11*SY, w=SXF, h=SY)
        self.lblLRSFIH07V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH07V.place(x=16*BX+15*SXF, y=12*BY+11*SY, w=SXF, h=SY)
        #--------------------------------------------------------------------
        # 7.row - FI08H - FI15H
        self.lblLRSFIH08N = TKI.Label(self.Parent, text='FI08H', bg=CBGH)
        self.lblLRSFIH08N.place(x=1*BX+0*SXF, y=13*BY+12*SY, w=SXF, h=SY)
        self.lblLRSFIH08V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH08V.place(x=2*BX+1*SXF, y=13*BY+12*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH09N = TKI.Label(self.Parent, text='FI09H', bg=CBGH)
        self.lblLRSFIH09N.place(x=3*BX+2*SXF, y=13*BY+12*SY, w=SXF, h=SY)
        self.lblLRSFIH09V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH09V.place(x=4*BX+3*SXF, y=13*BY+12*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH10N = TKI.Label(self.Parent, text='FI10H', bg=CBGH)
        self.lblLRSFIH10N.place(x=5*BX+4*SXF, y=13*BY+12*SY, w=SXF, h=SY)
        self.lblLRSFIH10V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH10V.place(x=6*BX+5*SXF, y=13*BY+12*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH11N = TKI.Label(self.Parent, text='FI11H', bg=CBGH)
        self.lblLRSFIH11N.place(x=7*BX+6*SXF, y=13*BY+12*SY, w=SXF, h=SY)
        self.lblLRSFIH11V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH11V.place(x=8*BX+7*SXF, y=13*BY+12*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH12N = TKI.Label(self.Parent, text='FI12H', bg=CBGH)
        self.lblLRSFIH12N.place(x=9*BX+8*SXF, y=13*BY+12*SY, w=SXF, h=SY)
        self.lblLRSFIH12V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH12V.place(x=10*BX+9*SXF, y=13*BY+12*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH13N = TKI.Label(self.Parent, text='FI13H', bg=CBGH)
        self.lblLRSFIH13N.place(x=11*BX+10*SXF, y=13*BY+12*SY, w=SXF, h=SY)
        self.lblLRSFIH13V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH13V.place(x=12*BX+11*SXF, y=13*BY+12*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH14N = TKI.Label(self.Parent, text='FI14H', bg=CBGH)
        self.lblLRSFIH14N.place(x=13*BX+12*SXF, y=13*BY+12*SY, w=SXF, h=SY)
        self.lblLRSFIH14V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH14V.place(x=14*BX+13*SXF, y=13*BY+12*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH15N = TKI.Label(self.Parent, text='FI15H', bg=CBGH)
        self.lblLRSFIH15N.place(x=15*BX+14*SXF, y=13*BY+12*SY, w=SXF, h=SY)
        self.lblLRSFIH15V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH15V.place(x=16*BX+15*SXF, y=13*BY+12*SY, w=SXF, h=SY)
        #--------------------------------------------------------------------
        # 8.row - FI16H - FI23H
        self.lblLRSFIH16N = TKI.Label(self.Parent, text='FI16H', bg=CBGH)
        self.lblLRSFIH16N.place(x=1*BX+0*SXF, y=14*BY+13*SY, w=SXF, h=SY)
        self.lblLRSFIH16V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH16V.place(x=2*BX+1*SXF, y=14*BY+13*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH17N = TKI.Label(self.Parent, text='FI17H', bg=CBGH)
        self.lblLRSFIH17N.place(x=3*BX+2*SXF, y=14*BY+13*SY, w=SXF, h=SY)
        self.lblLRSFIH17V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH17V.place(x=4*BX+3*SXF, y=14*BY+13*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH18N = TKI.Label(self.Parent, text='FI18H', bg=CBGH)
        self.lblLRSFIH18N.place(x=5*BX+4*SXF, y=14*BY+13*SY, w=SXF, h=SY)
        self.lblLRSFIH18V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH18V.place(x=6*BX+5*SXF, y=14*BY+13*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH19N = TKI.Label(self.Parent, text='FI19H', bg=CBGH)
        self.lblLRSFIH19N.place(x=7*BX+6*SXF, y=14*BY+13*SY, w=SXF, h=SY)
        self.lblLRSFIH19V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH19V.place(x=8*BX+7*SXF, y=14*BY+13*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH20N = TKI.Label(self.Parent, text='FI20H', bg=CBGH)
        self.lblLRSFIH20N.place(x=9*BX+8*SXF, y=14*BY+13*SY, w=SXF, h=SY)
        self.lblLRSFIH20V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH20V.place(x=10*BX+9*SXF, y=14*BY+13*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH21N = TKI.Label(self.Parent, text='FI21H', bg=CBGH)
        self.lblLRSFIH21N.place(x=11*BX+10*SXF, y=14*BY+13*SY, w=SXF, h=SY)
        self.lblLRSFIH21V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH21V.place(x=12*BX+11*SXF, y=14*BY+13*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH22N = TKI.Label(self.Parent, text='FI22H', bg=CBGH)
        self.lblLRSFIH22N.place(x=13*BX+12*SXF, y=14*BY+13*SY, w=SXF, h=SY)
        self.lblLRSFIH22V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH22V.place(x=14*BX+13*SXF, y=14*BY+13*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH23N = TKI.Label(self.Parent, text='FI23H', bg=CBGH)
        self.lblLRSFIH23N.place(x=15*BX+14*SXF, y=14*BY+13*SY, w=SXF, h=SY)
        self.lblLRSFIH23V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH23V.place(x=16*BX+15*SXF, y=14*BY+13*SY, w=SXF, h=SY)
        #--------------------------------------------------------------------
        # 9.row - FI24H - FI31H
        self.lblLRSFIH24N = TKI.Label(self.Parent, text='FI24H', bg=CBGH)
        self.lblLRSFIH24N.place(x=1*BX+0*SXF, y=15*BY+14*SY, w=SXF, h=SY)
        self.lblLRSFIH24V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH24V.place(x=2*BX+1*SXF, y=15*BY+14*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH25N = TKI.Label(self.Parent, text='FI25H', bg=CBGH)
        self.lblLRSFIH25N.place(x=3*BX+2*SXF, y=15*BY+14*SY, w=SXF, h=SY)
        self.lblLRSFIH25V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH25V.place(x=4*BX+3*SXF, y=15*BY+14*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH26N = TKI.Label(self.Parent, text='FI26H', bg=CBGH)
        self.lblLRSFIH26N.place(x=5*BX+4*SXF, y=15*BY+14*SY, w=SXF, h=SY)
        self.lblLRSFIH26V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH26V.place(x=6*BX+5*SXF, y=15*BY+14*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH27N = TKI.Label(self.Parent, text='FI27H', bg=CBGH)
        self.lblLRSFIH27N.place(x=7*BX+6*SXF, y=15*BY+14*SY, w=SXF, h=SY)
        self.lblLRSFIH27V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH27V.place(x=8*BX+7*SXF, y=15*BY+14*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH28N = TKI.Label(self.Parent, text='FI28H', bg=CBGH)
        self.lblLRSFIH28N.place(x=9*BX+8*SXF, y=15*BY+14*SY, w=SXF, h=SY)
        self.lblLRSFIH28V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH28V.place(x=10*BX+9*SXF, y=15*BY+14*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH29N = TKI.Label(self.Parent, text='FI29H', bg=CBGH)
        self.lblLRSFIH29N.place(x=11*BX+10*SXF, y=15*BY+14*SY, w=SXF, h=SY)
        self.lblLRSFIH29V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH29V.place(x=12*BX+11*SXF, y=15*BY+14*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH30N = TKI.Label(self.Parent, text='FI30H', bg=CBGH)
        self.lblLRSFIH30N.place(x=13*BX+12*SXF, y=15*BY+14*SY, w=SXF, h=SY)
        self.lblLRSFIH30V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH30V.place(x=14*BX+13*SXF, y=15*BY+14*SY, w=SXF, h=SY)
        #
        self.lblLRSFIH31N = TKI.Label(self.Parent, text='FI31H', bg=CBGH)
        self.lblLRSFIH31N.place(x=15*BX+14*SXF, y=15*BY+14*SY, w=SXF, h=SY)
        self.lblLRSFIH31V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIH31V.place(x=16*BX+15*SXF, y=15*BY+14*SY, w=SXF, h=SY)
        #--------------------------------------------------------------------
        # 10.row - FI00A - FI08A
        self.lblLRSFIA00N = TKI.Label(self.Parent, text='FI00A', bg=CBGH)
        self.lblLRSFIA00N.place(x=1*BX+0*SXF, y=16*BY+15*SY, w=SXF, h=SY)
        self.lblLRSFIA00V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA00V.place(x=2*BX+1*SXF, y=16*BY+15*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA01N = TKI.Label(self.Parent, text='FI01A', bg=CBGH)
        self.lblLRSFIA01N.place(x=3*BX+2*SXF, y=16*BY+15*SY, w=SXF, h=SY)
        self.lblLRSFIA01V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA01V.place(x=4*BX+3*SXF, y=16*BY+15*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA02N = TKI.Label(self.Parent, text='FI02A', bg=CBGH)
        self.lblLRSFIA02N.place(x=5*BX+4*SXF, y=16*BY+15*SY, w=SXF, h=SY)
        self.lblLRSFIA02V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA02V.place(x=6*BX+5*SXF, y=16*BY+15*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA03N = TKI.Label(self.Parent, text='FI03A', bg=CBGH)
        self.lblLRSFIA03N.place(x=7*BX+6*SXF, y=16*BY+15*SY, w=SXF, h=SY)
        self.lblLRSFIA03V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA03V.place(x=8*BX+7*SXF, y=16*BY+15*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA04N = TKI.Label(self.Parent, text='FI04A', bg=CBGH)
        self.lblLRSFIA04N.place(x=9*BX+8*SXF, y=16*BY+15*SY, w=SXF, h=SY)
        self.lblLRSFIA04V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA04V.place(x=10*BX+9*SXF, y=16*BY+15*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA05N = TKI.Label(self.Parent, text='FI05A', bg=CBGH)
        self.lblLRSFIA05N.place(x=11*BX+10*SXF, y=16*BY+15*SY, w=SXF, h=SY)
        self.lblLRSFIA05V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA05V.place(x=12*BX+11*SXF, y=16*BY+15*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA06N = TKI.Label(self.Parent, text='FI06A', bg=CBGH)
        self.lblLRSFIA06N.place(x=13*BX+12*SXF, y=16*BY+15*SY, w=SXF, h=SY)
        self.lblLRSFIA06V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA06V.place(x=14*BX+13*SXF, y=16*BY+15*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA07N = TKI.Label(self.Parent, text='FI07A', bg=CBGH)
        self.lblLRSFIA07N.place(x=15*BX+14*SXF, y=16*BY+15*SY, w=SXF, h=SY)
        self.lblLRSFIA07V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA07V.place(x=16*BX+15*SXF, y=16*BY+15*SY, w=SXF, h=SY)
        #--------------------------------------------------------------------
        # 11.row - FI08A - FI15A
        self.lblLRSFIA08N = TKI.Label(self.Parent, text='FI08A', bg=CBGH)
        self.lblLRSFIA08N.place(x=1*BX+0*SXF, y=17*BY+16*SY, w=SXF, h=SY)
        self.lblLRSFIA08V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA08V.place(x=2*BX+1*SXF, y=17*BY+16*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA09N = TKI.Label(self.Parent, text='FI09A', bg=CBGH)
        self.lblLRSFIA09N.place(x=3*BX+2*SXF, y=17*BY+16*SY, w=SXF, h=SY)
        self.lblLRSFIA09V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA09V.place(x=4*BX+3*SXF, y=17*BY+16*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA10N = TKI.Label(self.Parent, text='FI10A', bg=CBGH)
        self.lblLRSFIA10N.place(x=5*BX+4*SXF, y=17*BY+16*SY, w=SXF, h=SY)
        self.lblLRSFIA10V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA10V.place(x=6*BX+5*SXF, y=17*BY+16*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA11N = TKI.Label(self.Parent, text='FI11A', bg=CBGH)
        self.lblLRSFIA11N.place(x=7*BX+6*SXF, y=17*BY+16*SY, w=SXF, h=SY)
        self.lblLRSFIA11V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA11V.place(x=8*BX+7*SXF, y=17*BY+16*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA12N = TKI.Label(self.Parent, text='FI12A', bg=CBGH)
        self.lblLRSFIA12N.place(x=9*BX+8*SXF, y=17*BY+16*SY, w=SXF, h=SY)
        self.lblLRSFIA12V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA12V.place(x=10*BX+9*SXF, y=17*BY+16*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA13N = TKI.Label(self.Parent, text='FI13A', bg=CBGH)
        self.lblLRSFIA13N.place(x=11*BX+10*SXF, y=17*BY+16*SY, w=SXF, h=SY)
        self.lblLRSFIA13V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA13V.place(x=12*BX+11*SXF, y=17*BY+16*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA14N = TKI.Label(self.Parent, text='FI14A', bg=CBGH)
        self.lblLRSFIA14N.place(x=13*BX+12*SXF, y=17*BY+16*SY, w=SXF, h=SY)
        self.lblLRSFIA14V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA14V.place(x=14*BX+13*SXF, y=17*BY+16*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA15N = TKI.Label(self.Parent, text='FI15A', bg=CBGH)
        self.lblLRSFIA15N.place(x=15*BX+14*SXF, y=17*BY+16*SY, w=SXF, h=SY)
        self.lblLRSFIA15V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA15V.place(x=16*BX+15*SXF, y=17*BY+16*SY, w=SXF, h=SY)
        #--------------------------------------------------------------------
        # 12.row - FI16A - FI23A
        self.lblLRSFIA16N = TKI.Label(self.Parent, text='FI16A', bg=CBGH)
        self.lblLRSFIA16N.place(x=1*BX+0*SXF, y=18*BY+17*SY, w=SXF, h=SY)
        self.lblLRSFIA16V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA16V.place(x=2*BX+1*SXF, y=18*BY+17*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA17N = TKI.Label(self.Parent, text='FI17A', bg=CBGH)
        self.lblLRSFIA17N.place(x=3*BX+2*SXF, y=18*BY+17*SY, w=SXF, h=SY)
        self.lblLRSFIA17V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA17V.place(x=4*BX+3*SXF, y=18*BY+17*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA18N = TKI.Label(self.Parent, text='FI18A', bg=CBGH)
        self.lblLRSFIA18N.place(x=5*BX+4*SXF, y=18*BY+17*SY, w=SXF, h=SY)
        self.lblLRSFIA18V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA18V.place(x=6*BX+5*SXF, y=18*BY+17*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA19N = TKI.Label(self.Parent, text='FI19A', bg=CBGH)
        self.lblLRSFIA19N.place(x=7*BX+6*SXF, y=18*BY+17*SY, w=SXF, h=SY)
        self.lblLRSFIA19V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA19V.place(x=8*BX+7*SXF, y=18*BY+17*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA20N = TKI.Label(self.Parent, text='FI20A', bg=CBGH)
        self.lblLRSFIA20N.place(x=9*BX+8*SXF, y=18*BY+17*SY, w=SXF, h=SY)
        self.lblLRSFIA20V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA20V.place(x=10*BX+9*SXF, y=18*BY+17*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA21N = TKI.Label(self.Parent, text='FI21A', bg=CBGH)
        self.lblLRSFIA21N.place(x=11*BX+10*SXF, y=18*BY+17*SY, w=SXF, h=SY)
        self.lblLRSFIA21V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA21V.place(x=12*BX+11*SXF, y=18*BY+17*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA22N = TKI.Label(self.Parent, text='FI22A', bg=CBGH)
        self.lblLRSFIA22N.place(x=13*BX+12*SXF, y=18*BY+17*SY, w=SXF, h=SY)
        self.lblLRSFIA22V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA22V.place(x=14*BX+13*SXF, y=18*BY+17*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA23N = TKI.Label(self.Parent, text='FI23A', bg=CBGH)
        self.lblLRSFIA23N.place(x=15*BX+14*SXF, y=18*BY+17*SY, w=SXF, h=SY)
        self.lblLRSFIA23V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA23V.place(x=16*BX+15*SXF, y=18*BY+17*SY, w=SXF, h=SY)
        #--------------------------------------------------------------------
        # 13.row - FI24A - FI31A
        self.lblLRSFIA24N = TKI.Label(self.Parent, text='FI24A', bg=CBGH)
        self.lblLRSFIA24N.place(x=1*BX+0*SXF, y=19*BY+18*SY, w=SXF, h=SY)
        self.lblLRSFIA24V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA24V.place(x=2*BX+1*SXF, y=19*BY+18*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA25N = TKI.Label(self.Parent, text='FI25A', bg=CBGH)
        self.lblLRSFIA25N.place(x=3*BX+2*SXF, y=19*BY+18*SY, w=SXF, h=SY)
        self.lblLRSFIA25V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA25V.place(x=4*BX+3*SXF, y=19*BY+18*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA26N = TKI.Label(self.Parent, text='FI26A', bg=CBGH)
        self.lblLRSFIA26N.place(x=5*BX+4*SXF, y=19*BY+18*SY, w=SXF, h=SY)
        self.lblLRSFIA26V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA26V.place(x=6*BX+5*SXF, y=19*BY+18*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA27N = TKI.Label(self.Parent, text='FI27A', bg=CBGH)
        self.lblLRSFIA27N.place(x=7*BX+6*SXF, y=19*BY+18*SY, w=SXF, h=SY)
        self.lblLRSFIA27V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA27V.place(x=8*BX+7*SXF, y=19*BY+18*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA28N = TKI.Label(self.Parent, text='FI28A', bg=CBGH)
        self.lblLRSFIA28N.place(x=9*BX+8*SXF, y=19*BY+18*SY, w=SXF, h=SY)
        self.lblLRSFIA28V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA28V.place(x=10*BX+9*SXF, y=19*BY+18*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA29N = TKI.Label(self.Parent, text='FI29A', bg=CBGH)
        self.lblLRSFIA29N.place(x=11*BX+10*SXF, y=19*BY+18*SY, w=SXF, h=SY)
        self.lblLRSFIA29V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA29V.place(x=12*BX+11*SXF, y=19*BY+18*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA30N = TKI.Label(self.Parent, text='FI30A', bg=CBGH)
        self.lblLRSFIA30N.place(x=13*BX+12*SXF, y=19*BY+18*SY, w=SXF, h=SY)
        self.lblLRSFIA30V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA30V.place(x=14*BX+13*SXF, y=19*BY+18*SY, w=SXF, h=SY)
        #
        self.lblLRSFIA31N = TKI.Label(self.Parent, text='FI31A', bg=CBGH)
        self.lblLRSFIA31N.place(x=15*BX+14*SXF, y=19*BY+18*SY, w=SXF, h=SY)
        self.lblLRSFIA31V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSFIA31V.place(x=16*BX+15*SXF, y=19*BY+18*SY, w=SXF, h=SY)
        #--------------------------------------------------------------------
        # 14.row - HK00C - HK08C
        self.lblLRSHKC00N = TKI.Label(self.Parent, text='HK00C', bg=CBGH)
        self.lblLRSHKC00N.place(x=1*BX+0*SXF, y=20*BY+19*SY, w=SXF, h=SY)
        self.lblLRSHKC00V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSHKC00V.place(x=2*BX+1*SXF, y=20*BY+19*SY, w=SXF, h=SY)
        #
        self.lblLRSHKC01N = TKI.Label(self.Parent, text='HK01C', bg=CBGH)
        self.lblLRSHKC01N.place(x=3*BX+2*SXF, y=20*BY+19*SY, w=SXF, h=SY)
        self.lblLRSHKC01V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSHKC01V.place(x=4*BX+3*SXF, y=20*BY+19*SY, w=SXF, h=SY)
        #
        self.lblLRSHKC02N = TKI.Label(self.Parent, text='HK02C', bg=CBGH)
        self.lblLRSHKC02N.place(x=5*BX+4*SXF, y=20*BY+19*SY, w=SXF, h=SY)
        self.lblLRSHKC02V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSHKC02V.place(x=6*BX+5*SXF, y=20*BY+19*SY, w=SXF, h=SY)
        #
        self.lblLRSHKC03N = TKI.Label(self.Parent, text='HK03C', bg=CBGH)
        self.lblLRSHKC03N.place(x=7*BX+6*SXF, y=20*BY+19*SY, w=SXF, h=SY)
        self.lblLRSHKC03V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSHKC03V.place(x=8*BX+7*SXF, y=20*BY+19*SY, w=SXF, h=SY)
        #
        self.lblLRSHKC04N = TKI.Label(self.Parent, text='HK04C', bg=CBGH)
        self.lblLRSHKC04N.place(x=9*BX+8*SXF, y=20*BY+19*SY, w=SXF, h=SY)
        self.lblLRSHKC04V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSHKC04V.place(x=10*BX+9*SXF, y=20*BY+19*SY, w=SXF, h=SY)
        #
        self.lblLRSHKC05N = TKI.Label(self.Parent, text='HK05C', bg=CBGH)
        self.lblLRSHKC05N.place(x=11*BX+10*SXF, y=20*BY+19*SY, w=SXF, h=SY)
        self.lblLRSHKC05V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSHKC05V.place(x=12*BX+11*SXF, y=20*BY+19*SY, w=SXF, h=SY)
        #
        self.lblLRSHKC06N = TKI.Label(self.Parent, text='HK06C', bg=CBGH)
        self.lblLRSHKC06N.place(x=13*BX+12*SXF, y=20*BY+19*SY, w=SXF, h=SY)
        self.lblLRSHKC06V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSHKC06V.place(x=14*BX+13*SXF, y=20*BY+19*SY, w=SXF, h=SY)
        #
        self.lblLRSHKC07N = TKI.Label(self.Parent, text='HK07C', bg=CBGH)
        self.lblLRSHKC07N.place(x=15*BX+14*SXF, y=20*BY+19*SY, w=SXF, h=SY)
        self.lblLRSHKC07V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSHKC07V.place(x=16*BX+15*SXF, y=20*BY+19*SY, w=SXF, h=SY)
        #--------------------------------------------------------------------
        # 15.row - HK00H - HK08H
        self.lblLRSHKH00N = TKI.Label(self.Parent, text='HK00H', bg=CBGH)
        self.lblLRSHKH00N.place(x=1*BX+0*SXF, y=21*BY+20*SY, w=SXF, h=SY)
        self.lblLRSHKH00V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSHKH00V.place(x=2*BX+1*SXF, y=21*BY+20*SY, w=SXF, h=SY)
        #
        self.lblLRSHKH01N = TKI.Label(self.Parent, text='HK01H', bg=CBGH)
        self.lblLRSHKH01N.place(x=3*BX+2*SXF, y=21*BY+20*SY, w=SXF, h=SY)
        self.lblLRSHKH01V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSHKH01V.place(x=4*BX+3*SXF, y=21*BY+20*SY, w=SXF, h=SY)
        #
        self.lblLRSHKH02N = TKI.Label(self.Parent, text='HK02H', bg=CBGH)
        self.lblLRSHKH02N.place(x=5*BX+4*SXF, y=21*BY+20*SY, w=SXF, h=SY)
        self.lblLRSHKH02V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSHKH02V.place(x=6*BX+5*SXF, y=21*BY+20*SY, w=SXF, h=SY)
        #
        self.lblLRSHKH03N = TKI.Label(self.Parent, text='HK03H', bg=CBGH)
        self.lblLRSHKH03N.place(x=7*BX+6*SXF, y=21*BY+20*SY, w=SXF, h=SY)
        self.lblLRSHKH03V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSHKH03V.place(x=8*BX+7*SXF, y=21*BY+20*SY, w=SXF, h=SY)
        #
        self.lblLRSHKH04N = TKI.Label(self.Parent, text='HK04H', bg=CBGH)
        self.lblLRSHKH04N.place(x=9*BX+8*SXF, y=21*BY+20*SY, w=SXF, h=SY)
        self.lblLRSHKH04V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSHKH04V.place(x=10*BX+9*SXF, y=21*BY+20*SY, w=SXF, h=SY)
        #
        self.lblLRSHKH05N = TKI.Label(self.Parent, text='HK05H', bg=CBGH)
        self.lblLRSHKH05N.place(x=11*BX+10*SXF, y=21*BY+20*SY, w=SXF, h=SY)
        self.lblLRSHKH05V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSHKH05V.place(x=12*BX+11*SXF, y=21*BY+20*SY, w=SXF, h=SY)
        #
        self.lblLRSHKH06N = TKI.Label(self.Parent, text='HK06H', bg=CBGH)
        self.lblLRSHKH06N.place(x=13*BX+12*SXF, y=21*BY+20*SY, w=SXF, h=SY)
        self.lblLRSHKH06V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSHKH06V.place(x=14*BX+13*SXF, y=21*BY+20*SY, w=SXF, h=SY)
        #
        self.lblLRSHKH07N = TKI.Label(self.Parent, text='HK07H', bg=CBGH)
        self.lblLRSHKH07N.place(x=15*BX+14*SXF, y=21*BY+20*SY, w=SXF, h=SY)
        self.lblLRSHKH07V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSHKH07V.place(x=16*BX+15*SXF, y=21*BY+20*SY, w=SXF, h=SY)
        #--------------------------------------------------------------------
        # 16.row - HK00A - HK08A
        self.lblLRSHKA00N = TKI.Label(self.Parent, text='HK00A', bg=CBGH)
        self.lblLRSHKA00N.place(x=1*BX+0*SXF, y=22*BY+21*SY, w=SXF, h=SY)
        self.lblLRSHKA00V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSHKA00V.place(x=2*BX+1*SXF, y=22*BY+21*SY, w=SXF, h=SY)
        #
        self.lblLRSHKA01N = TKI.Label(self.Parent, text='HK01A', bg=CBGH)
        self.lblLRSHKA01N.place(x=3*BX+2*SXF, y=22*BY+21*SY, w=SXF, h=SY)
        self.lblLRSHKA01V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSHKA01V.place(x=4*BX+3*SXF, y=22*BY+21*SY, w=SXF, h=SY)
        #
        self.lblLRSHKA02N = TKI.Label(self.Parent, text='HK02A', bg=CBGH)
        self.lblLRSHKA02N.place(x=5*BX+4*SXF, y=22*BY+21*SY, w=SXF, h=SY)
        self.lblLRSHKA02V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSHKA02V.place(x=6*BX+5*SXF, y=22*BY+21*SY, w=SXF, h=SY)
        #
        self.lblLRSHKA03N = TKI.Label(self.Parent, text='HK03A', bg=CBGH)
        self.lblLRSHKA03N.place(x=7*BX+6*SXF, y=22*BY+21*SY, w=SXF, h=SY)
        self.lblLRSHKA03V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSHKA03V.place(x=8*BX+7*SXF, y=22*BY+21*SY, w=SXF, h=SY)
        #
        self.lblLRSHKA04N = TKI.Label(self.Parent, text='HK04A', bg=CBGH)
        self.lblLRSHKA04N.place(x=9*BX+8*SXF, y=22*BY+21*SY, w=SXF, h=SY)
        self.lblLRSHKA04V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSHKA04V.place(x=10*BX+9*SXF, y=22*BY+21*SY, w=SXF, h=SY)
        #
        self.lblLRSHKA05N = TKI.Label(self.Parent, text='HK05A', bg=CBGH)
        self.lblLRSHKA05N.place(x=11*BX+10*SXF, y=22*BY+21*SY, w=SXF, h=SY)
        self.lblLRSHKA05V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSHKA05V.place(x=12*BX+11*SXF, y=22*BY+21*SY, w=SXF, h=SY)
        #
        self.lblLRSHKA06N = TKI.Label(self.Parent, text='HK06A', bg=CBGH)
        self.lblLRSHKA06N.place(x=13*BX+12*SXF, y=22*BY+21*SY, w=SXF, h=SY)
        self.lblLRSHKA06V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSHKA06V.place(x=14*BX+13*SXF, y=22*BY+21*SY, w=SXF, h=SY)
        #
        self.lblLRSHKA07N = TKI.Label(self.Parent, text='HK07A', bg=CBGH)
        self.lblLRSHKA07N.place(x=15*BX+14*SXF, y=22*BY+21*SY, w=SXF, h=SY)
        self.lblLRSHKA07V = TKI.Label(self.Parent, text='0', bg=CBGV)
        self.lblLRSHKA07V.place(x=16*BX+15*SXF, y=22*BY+21*SY, w=SXF, h=SY)
        #
    #
    def SetOnInfo(self, oninfo):
        self.OnInfo = oninfo
    #
    def Info(self, text):
        if (None != self.OnInfo):
            self.OnInfo(text)        
    #
#----------------------------------------------------------------------
#  Main
#----------------------------------------------------------------------
if ('__main__' == __name__):
    #
    print('*** FramePlot: begin')
    #
    #
    print('*** FramePlot: end')
    #
#    