#
import re
#
import Observable as OBS
#
#----------------------------------------------------------------------
#   CConverterGPSLRS
#----------------------------------------------------------------------
class CConverterGPSLRS():
    #
    def __init__(self):
        self.Tokenlist = []
        # GPS
        self.GPSDate = OBS.CDate('Date')
        self.GPSTime = OBS.CTime('Time')
        self.GPSLatitude = OBS.CFloat32('Latitude')
        self.GPSLongitude = OBS.CFloat32('Longitude')
        self.GPSAltitude = OBS.CFloat32('Altitude')
        self.GPSSatellites = OBS.CUInt32('Satellites')
        self.GPSPrecision = OBS.CUInt32('Precision')
        self.GPSCharacters = OBS.CUInt32('Characters')
        self.GPSGood = OBS.CUInt32('Goods')
        self.GPSErrors = OBS.CUInt32('Errors')
        self.OnGPSRefreshDateTime = None
        self.OnGPSRefreshLocation = None
        self.OnGPSRefreshQuality = None
        # LRS
        self.LRSName = OBS.CText('Name')
        self.LRSDate = OBS.CDate('Date')
        self.LRSTime = OBS.CTime('Time')
        self.LRSCycleCount = OBS.CUInt32('CycleCount')
        self.LRSZenithAngle = OBS.CFloat32('ZenithAngle')
        self.LRSCycleTime = OBS.CUInt32('CycleTime')
        self.LRSTcold = OBS.CFloat32('Tcold')
        self.LRSThot = OBS.CFloat32('Thot')
        self.LRSFIC = []
        self.LRSFIH = []
        self.LRSFIA = []
        for I in range(0, 32):
            self.LRSFIC.append(OBS.CUInt32('LRSFIC{}'.format(I)))
            self.LRSFIH.append(OBS.CUInt32('LRSFIH{}'.format(I)))
            self.LRSFIA.append(OBS.CUInt32('LRSFIA{}'.format(I)))
        self.LRSHKC = []
        self.LRSHKH = []
        self.LRSHKA = []
        for I in range(0, 8):
            self.LRSHKC.append(OBS.CUInt32('LRSHKC{}'.format(I)))
            self.LRSHKH.append(OBS.CUInt32('LRSHKH{}'.format(I)))
            self.LRSHKA.append(OBS.CUInt32('LRSHKA{}'.format(I)))
        self.OnLRSRefreshHeader = None
        self.OnLRSRefreshFI00C = None
        self.OnLRSRefreshFI08C = None
        self.OnLRSRefreshFI16C = None
        self.OnLRSRefreshFI24C = None
        self.OnLRSRefreshFI00H = None
        self.OnLRSRefreshFI08H = None
        self.OnLRSRefreshFI16H = None
        self.OnLRSRefreshFI24H = None
        self.OnLRSRefreshFI00A = None
        self.OnLRSRefreshFI08A = None
        self.OnLRSRefreshFI16A = None
        self.OnLRSRefreshFI24A = None
        self.OnLRSRefreshHK00C = None
        self.OnLRSRefreshHK00H = None
        self.OnLRSRefreshHK00A = None
        #
        self.OnRefreshDateTime = None
    # GPS
    def SetOnGPSRefreshDateTime(self, onevent):
        self.OnGPSRefreshDateTime = onevent
    def SetOnGPSRefreshLocation(self, onevent):
        self.OnGPSRefreshLocation = onevent
    def SetOnGPSRefreshQuality(self, onevent):
        self.OnGPSRefreshQuality = onevent
    # LRS
    def SetOnLRSRefreshHeader(self, onevent):
        self.OnLRSRefreshHeader = onevent
    def SetOnLRSRefreshFI00C(self, onevent):
        self.OnLRSRefreshFI00C = onevent
    def SetOnLRSRefreshFI08C(self, onevent):
        self.OnLRSRefreshFI08C = onevent
    def SetOnLRSRefreshFI16C(self, onevent):
        self.OnLRSRefreshFI16C = onevent
    def SetOnLRSRefreshFI24C(self, onevent):
        self.OnLRSRefreshFI24C = onevent
    def SetOnLRSRefreshFI00H(self, onevent):
        self.OnLRSRefreshFI00H = onevent
    def SetOnLRSRefreshFI08H(self, onevent):
        self.OnLRSRefreshFI08H = onevent
    def SetOnLRSRefreshFI16H(self, onevent):
        self.OnLRSRefreshFI16H = onevent
    def SetOnLRSRefreshFI24H(self, onevent):
        self.OnLRSRefreshFI24H = onevent
    def SetOnLRSRefreshFI00A(self, onevent):
        self.OnLRSRefreshFI00A = onevent
    def SetOnLRSRefreshFI08A(self, onevent):
        self.OnLRSRefreshFI08A = onevent
    def SetOnLRSRefreshFI16A(self, onevent):
        self.OnLRSRefreshFI16A = onevent
    def SetOnLRSRefreshFI24A(self, onevent):
        self.OnLRSRefreshFI24A = onevent
    def SetOnLRSRefreshHK00C(self, onevent):
        self.OnLRSRefreshHK00C = onevent
    def SetOnLRSRefreshHK00H(self, onevent):
        self.OnLRSRefreshHK00H = onevent
    def SetOnLRSRefreshHK00A(self, onevent):
        self.OnLRSRefreshHK00A = onevent
    #
    def Tokenize(self, separators, text):
        self.Tokenlist = list(filter(None, re.split(separators, text)))
        return 0 < len(self.Tokenlist)
    #
    def GetTokens(self):
        return self.Tokenlist
    def GetTokenCount(self):
        return len(self.Tokenlist)
    #
    def GetToken(self, index):
        if index < len(self.Tokenlist):
            return self.Tokenlist[index]
    #
    def InterpreteGPS(self):
        # print(self.Tokenlist)
        if ('DATE' == self.Tokenlist[1]):
            self.GPSDate.SetText(self.Tokenlist[2])
            if ('TIME' == self.Tokenlist[3]):
                self.GPSTime.SetText(self.Tokenlist[4])
            if (None != self.OnGPSRefreshDateTime):
                self.OnGPSRefreshDateTime(self.GPSDate, self.GPSTime)
            return True
        if ('LATITUDE' == self.Tokenlist[1]):
            Text = self.Tokenlist[2] + ' ' + self.Tokenlist[3]
            self.GPSLatitude.SetText(Text)
            if ('LONGITUDE' == self.Tokenlist[4]):
                Text = self.Tokenlist[5] + ' ' + self.Tokenlist[6]
                self.GPSLongitude.SetText(Text)
                if ('ALTITUDE' == self.Tokenlist[7]):
                    Text = self.Tokenlist[8] + ' ' + self.Tokenlist[9]
                    self.GPSAltitude.SetText(Text)
            if (None != self.OnGPSRefreshLocation):
                self.OnGPSRefreshLocation(self.GPSLatitude, self.GPSLongitude, 
                                          self.GPSAltitude)
            return True
        if ('SATELLITES' == self.Tokenlist[1]):
            self.GPSSatellites.SetText(self.Tokenlist[2])
            if ('PRECISION' == self.Tokenlist[3]):
                self.GPSPrecision.SetText(self.Tokenlist[4])
                if ('CHARACTERS' == self.Tokenlist[5]):
                    self.GPSCharacters.SetText(self.Tokenlist[6])                
                    if ('GOOD' == self.Tokenlist[7]):
                        self.GPSGood.SetText(self.Tokenlist[8])                
                        if ('ERRORS' == self.Tokenlist[9]):
                            self.GPSErrors.SetText(self.Tokenlist[10])
                            if (None != self.OnGPSRefreshQuality):
                                self.OnGPSRefreshQuality(self.GPSSatellites, \
                                                         self.GPSPrecision,
                                                         self.GPSCharacters,
                                                         self.GPSGood,
                                                         self.GPSErrors)
            return True
        return False
    #
    def InterpreteLRS(self):
        # debug print(self.Tokenlist)
        if ('HEADER' == self.Tokenlist[1]):
            # debug print(self.Tokenlist)
            self.LRSName.SetText(self.Tokenlist[2])
            self.LRSDate.SetText(self.Tokenlist[3])
            self.LRSTime.SetText(self.Tokenlist[4])
            self.LRSCycleCount.SetText(self.Tokenlist[5])
            self.LRSZenithAngle.SetText(self.Tokenlist[6])
            self.LRSCycleTime.SetText(self.Tokenlist[7])
            self.LRSTcold.SetText(self.Tokenlist[8])
            self.LRSThot.SetText(self.Tokenlist[9])
            if (None != self.OnLRSRefreshHeader):
                self.OnLRSRefreshHeader(self.LRSName, self.LRSDate, \
                                    self.LRSTime, self.LRSCycleCount, \
                                    self.LRSZenithAngle, self.LRSCycleTime, \
                                    self.LRSTcold, self.LRSThot)
            return True
        #-------------------------------------------------
        if ('FI00C' == self.Tokenlist[1]):
            for I in range(0, 8):
                self.LRSFIC[I].SetText(self.Tokenlist[2 + I])
            if (None != self.OnLRSRefreshFI00C):
                self.OnLRSRefreshFI00C(self.LRSFIC)
            return True
        if ('FI08C' == self.Tokenlist[1]):
            for I in range(8, 16):
                self.LRSFIC[I].SetText(self.Tokenlist[-6 + I])
            if (None != self.OnLRSRefreshFI08C):
                self.OnLRSRefreshFI08C(self.LRSFIC)
            return True
        if ('FI16C' == self.Tokenlist[1]):
            for I in range(16, 24):
                self.LRSFIC[I].SetText(self.Tokenlist[-14 + I])
            if (None != self.OnLRSRefreshFI16C):
                self.OnLRSRefreshFI16C(self.LRSFIC)
            return True
        if ('FI24C' == self.Tokenlist[1]):
            for I in range(24, 32):
                self.LRSFIC[I].SetText(self.Tokenlist[-22 + I])
            if (None != self.OnLRSRefreshFI24C):
                self.OnLRSRefreshFI24C(self.LRSFIC)
            return True
        #-------------------------------------------------
        if ('FI00H' == self.Tokenlist[1]):
            for I in range(0, 8):
                self.LRSFIH[I].SetText(self.Tokenlist[2 + I])
            if (None != self.OnLRSRefreshFI00H):
                self.OnLRSRefreshFI00H(self.LRSFIH)
            return True
        if ('FI08H' == self.Tokenlist[1]):
            for I in range(8, 16):
                self.LRSFIH[I].SetText(self.Tokenlist[-6 + I])
            if (None != self.OnLRSRefreshFI08H):
                self.OnLRSRefreshFI08H(self.LRSFIH)
            return True
        if ('FI16H' == self.Tokenlist[1]):
            for I in range(16, 24):
                self.LRSFIH[I].SetText(self.Tokenlist[-14 + I])
            if (None != self.OnLRSRefreshFI16H):
                self.OnLRSRefreshFI16H(self.LRSFIH)
            return True
        if ('FI24H' == self.Tokenlist[1]):
            for I in range(24, 32):
                self.LRSFIH[I].SetText(self.Tokenlist[-22 + I])
            if (None != self.OnLRSRefreshFI24H):
                self.OnLRSRefreshFI24H(self.LRSFIH)
            return True
        #-------------------------------------------------
        if ('FI00A' == self.Tokenlist[1]):
            for I in range(0, 8):
                self.LRSFIA[I].SetText(self.Tokenlist[2 + I])
            if (None != self.OnLRSRefreshFI00A):
                self.OnLRSRefreshFI00A(self.LRSFIA)
            return True
        if ('FI08A' == self.Tokenlist[1]):
            for I in range(8, 16):
                self.LRSFIA[I].SetText(self.Tokenlist[-6 + I])
            if (None != self.OnLRSRefreshFI08A):
                self.OnLRSRefreshFI08A(self.LRSFIA)
            return True
        if ('FI16A' == self.Tokenlist[1]):
            for I in range(16, 24):
                self.LRSFIA[I].SetText(self.Tokenlist[-14 + I])
            if (None != self.OnLRSRefreshFI16A):
                self.OnLRSRefreshFI16A(self.LRSFIA)
            return True
        if ('FI24A' == self.Tokenlist[1]):
            for I in range(24, 32):
                self.LRSFIA[I].SetText(self.Tokenlist[-22 + I])
            if (None != self.OnLRSRefreshFI24A):
                self.OnLRSRefreshFI24A(self.LRSFIA)
            return True
        #-------------------------------------------------
        if ('HK00C' == self.Tokenlist[1]):
            for I in range(0, 8):
                self.LRSHKC[I].SetText(self.Tokenlist[2 + I])
            if (None != self.OnLRSRefreshHK00C):
                self.OnLRSRefreshHK00C(self.LRSHKC)
            return True
        if ('HK00H' == self.Tokenlist[1]):
            for I in range(0, 8):
                self.LRSHKH[I].SetText(self.Tokenlist[2 + I])
            if (None != self.OnLRSRefreshHK00H):
                self.OnLRSRefreshHK00H(self.LRSHKH)
            return True
        if ('HK00A' == self.Tokenlist[1]):
            for I in range(0, 8):
                self.LRSHKA[I].SetText(self.Tokenlist[2 + I])
            if (None != self.OnLRSRefreshHK00A):
                self.OnLRSRefreshHK00A(self.LRSHKA)
            return True        
        #-------------------------------------------------
        return False
    #
    def InterpreteRxLine(self, rxline):
        if (0 < len(rxline)):
            if (self.Tokenize('\>|\ |\[|\]', rxline)):
                # debug print(self.GetTokens())
                if (2 <= self.GetTokenCount()):
                    if ('GPS' == self.GetToken(0)):
                        return self.InterpreteGPS()
                    if ('LRS' == self.GetToken(0)):
                        return self.InterpreteLRS()
        return False

            #     X = float(Convert.GetToken(1))
            #     if (X <= 0.0):
            #         ResetPlot = True
            #     Y = float(Convert.GetToken(2))
            #     LI = len(VX) - 1
            #     if (0 <= LI):
            #         if (VX[LI] < X):
            #             VX.append(X)
            #             VY.append(Y)
            #     else:
            #         VX.append(X)
            #         VY.append(Y)


#
#----------------------------------------------------------------------
#   Main
#----------------------------------------------------------------------
#
# GPS>DATE[26.11.2021] TIME[19:41:09.000]<\r><\n>
# GPS>LATITUDE[51.655415]deg LONGITUDE[10.127163]deg ALTITUDE[158.800]m<\r><\n>
# GPS>SATELLITES[5] PRECISION[187] CHARACTERS[40575] GOOD[175] ERRORS[1]<\r><\n>
#
# LRS>HEADER[SinNoise 211120 101103 18 +45.2 5000 -18.0 +76.4]<\r><\n>
# LRS>FI00C[-00063 -00056 -00059 -00063 -00061 -00062 -00060 -00059]<\r><\n>
# LRS>FI08C[-00059 -00054 -00061 -00062 -00057 -00059 -00057 -00056]<\r><\n>
# LRS>FI16C[-00062 -00059 -00056 -00063 -00061 -00054 -00055 -00057]<\r><\n>
# LRS>FI24C[-00063 -00058 -00058 -00056 -00054 -00056 -00059 -00061]<\r><\n>
# LRS>FI00H[-00060 -00055 -00061 -00058 -00060 -00063 -00053 -00057]<\r><\n>
# LRS>FI08H[-00056 -00061 -00055 -00054 -00060 -00054 -00054 -00060]<\r><\n>
# LRS>FI16H[-00054 -00055 -00059 -00062 -00062 -00057 -00062 -00063]<\r><\n>
# LRS>FI24H[-00057 -00055 -00055 -00063 -00063 -00053 -00056 -00057]<\r><\n>
# LRS>FI00A[-00059 -00054 -00061 -00058 -00062 -00058 -00056 -00059]<\r><\n>
# LRS>FI08A[-00054 -00057 -00056 -00063 -00061 -00056 -00061 -00056]<\r><\n>
# LRS>FI16A[-00054 -00055 -00057 -00063 -00062 -00062 -00055 -00059]<\r><\n>
# LRS>FI24A[-00054 -00058 -00058 -00054 -00063 -00057 -00057 -00059]<\r><\n>
# LRS>HK00C[-00058 -00057 -00056 -00061 -00057 -00062 -00054 -00058]<\r><\n>
# LRS>HK00H[-00063 -00057 -00058 -00054 -00057 -00062 -00060 -00054]<\r><\n>
# LRS>HK00A[-00059 -00054 -00054 -00055 -00057 -00061 -00063 -00062]<\r><\n>
#
SEPARATORS_GPS = ' |,|>|\[|\]|\r|\n'
SEPARATORS_LRS = ' |,|>|\[|\]|\r|\n'
#
Date = OBS.CDate('Date')#, 0, 0, 0)
Time = OBS.CTime('Time')#00:00:00.000'
LatitudeV = 0.0
LatitudeU = ''
LongitudeV = 0.0
LongitudeU = ''
AltitudeV = 0.0
AltiudeU = ''
SatellitesV = 0
PrecisionV = 0
CharactersV = 0
GoodV = 0
ErrorsV = 0
#
#

#
if ('__main__' == __name__):
    #
    print('*** Converter: begin')
    #
    Convert = CConverter()
    #
    LineGPS0 = 'GPS>DATE[26.11.2021] TIME[19:41:09.000]\r\n'
    LineGPS1 = 'GPS>LATITUDE[51.655415]deg LONGITUDE[10.127163]deg ALTITUDE[158.800]m\r\n'
    LineGPS2 = 'GPS>SATELLITES[5] PRECISION[187] CHARACTERS[40575] GOOD[175] ERRORS[1]\r\n'
    LineLRS0 = 'LRS>HEADER[SinNoise 211120 101103 18 +45.2 5000 -18.0 +76.4]\r\n'
    LineLRS1 = 'LRS>FI00C[-00063 -00056 -00059 -00063 -00061 -00062 -00060 -00059]\r\n'
    LineLRS2 = 'LRS>FI08C[-00059 -00054 -00061 -00062 -00057 -00059 -00057 -00056]\r\n'
    LineLRS3 = 'LRS>FI16C[-00062 -00059 -00056 -00063 -00061 -00054 -00055 -00057]\r\n'
    LineLRS4 = 'LRS>FI24C[-00063 -00058 -00058 -00056 -00054 -00056 -00059 -00061]\r\n'
    LineLRS5 = 'LRS>FI00H[-00060 -00055 -00061 -00058 -00060 -00063 -00053 -00057]\r\n'
    #-----------------------------------------------
    if Convert.Tokenize(SEPARATORS_GPS, LineGPS0):
        print(Convert.GetTokens())
        if ('GPS' == Convert.GetToken(0)):
            InterpreteGPS(Convert.GetTokens())
    if Convert.Tokenize(SEPARATORS_GPS, LineGPS1):
        print(Convert.GetTokens())
        if ('GPS' == Convert.GetToken(0)):
            InterpreteGPS(Convert.GetTokens())
    if Convert.Tokenize(SEPARATORS_GPS, LineGPS2):
        print(Convert.GetTokens())
        if ('GPS' == Convert.GetToken(0)):
            InterpreteGPS(Convert.GetTokens())
    #
    #-----------------------------------------------
    if Convert.Tokenize(SEPARATORS_LRS, LineLRS0):
        print(Convert.GetTokens())
        if ('LRS' == Convert.GetToken(0)):
            InterpreteLRS(Convert.GetTokens())
    if Convert.Tokenize(SEPARATORS_LRS, LineLRS1):
        print(Convert.GetTokens())
        if ('LRS' == Convert.GetToken(0)):
            InterpreteLRS(Convert.GetTokens())
    if Convert.Tokenize(SEPARATORS_LRS, LineLRS2):
        print(Convert.GetTokens())
        if ('LRS' == Convert.GetToken(0)):
            InterpreteLRS(Convert.GetTokens())
    if Convert.Tokenize(SEPARATORS_LRS, LineLRS3):
        print(Convert.GetTokens())
        if ('LRS' == Convert.GetToken(0)):
            InterpreteLRS(Convert.GetTokens())
    if Convert.Tokenize(SEPARATORS_LRS, LineLRS4):
        print(Convert.GetTokens())
        if ('LRS' == Convert.GetToken(0)):
            InterpreteLRS(Convert.GetTokens())
    if Convert.Tokenize(SEPARATORS_LRS, LineLRS5):
        print(Convert.GetTokens())        
        if ('LRS' == Convert.GetToken(0)):
            InterpreteLRS(Convert.GetTokens())
    #
    print(Date.Name, Date.Day, Date.Month, Date.Year, \
          Time.Name, Time.Hours, Time.Minutes, Time.Millis)
    print(LatitudeV, LatitudeU, LongitudeV, LongitudeU, AltitudeV, AltitudeU)
    print(SatellitesV, PrecisionV, CharactersV, GoodV, ErrorsV)    
    #
    print('*** Converter: end')
    #
#


#--------------------------------------------------------------------------
# def InterpreteGPS(tokenlist):
#     global Date, Time
#     global LatitudeV, LatitudeU
#     global LongitudeV, LongitudeU
#     global AltitudeV, AltitudeU
#     global SatellitesV, PrecisionV, CharactersV, GoodV, ErrorsV
#     #
#     if ('DATE' == tokenlist[1]):
#         Date.SetText(tokenlist[2])
#         if ('TIME' == tokenlist[3]):
#             Time.SetText(tokenlist[4])
#         return
#     if ('LATITUDE' == tokenlist[1]):
#         LatitudeV = float(tokenlist[2])
#         LatitudeU = tokenlist[3]
#         if ('LONGITUDE' == tokenlist[4]):
#             LongitudeV = float(tokenlist[5])
#             LongitudeU = tokenlist[6]
#             if ('ALTITUDE' == tokenlist[7]):
#                 AltitudeV = float(tokenlist[8])                
#                 AltitudeU = tokenlist[9]
#         return    
#     if ('SATELLITES' == tokenlist[1]):
#         SatellitesV = int(tokenlist[2])
#         if ('PRECISION' == tokenlist[3]):
#             PrecisionV = int(tokenlist[4])
#             if ('CHARACTERS' == tokenlist[5]):
#                 CharactersV = int(tokenlist[6])                
#                 if ('GOOD' == tokenlist[7]):
#                     GoodV = int(tokenlist[8])                
#                     if ('ERRORS' == tokenlist[9]):
#                         ErrorsV = int(tokenlist[10])                
#         return    
