#
import re
#
class CObservable():
    #
    def __init__(self, name, unit=''):
        self.Name = name
        self.Unit = unit
        #
    def GetName(self):
        return self.Name
    def GetUnit(self):
        return self.Unit
    def SetText(self, text):
        return
    #
#
class CText(CObservable):
    #
    def __init__(self, name):
        super(CText, self).__init__(name)
        self.Value = ''
    #
    def GetValue(self):
        return self.Value
    #
    def SetText(self, text):
        self.Value = text
#
class CDate(CObservable):
    #
    def __init__(self, name):
        super(CDate, self).__init__(name)
        self.Year = 0
        self.Month = 0
        self.Day = 0
    #
    def GetYear(self):
        return self.Year
    def GetMonth(self):
        return self.Month
    def GetDay(self):
        return self.Day
    #
    def SetText(self, text):
        Tokens = list(filter(None, re.split('\.', text)))
        if (3 <= len(Tokens)):
            self.Day = int(Tokens[0])
            self.Month = int(Tokens[1])
            self.Year = int(Tokens[2])
        else:
            self.Day = int(text[0:2])
            self.Month = int(text[2:4])
            self.Year = int(text[4:8])
#
class CTime(CObservable):
    #
    def __init__(self, name, hours=0, minutes=0, seconds=0, millis=0):
        super(CTime, self).__init__(name)
        self.Hours = 0
        self.Minutes = 0
        self.Seconds = 0
        self.Millis = 0
    #
    def GetHours(self):
        return self.Hours
    def GetMinutes(self):
        return self.Minutes
    def GetSeconds(self):
        return self.Seconds
    def GetMillis(self):
        return self.Millis
    #
    def SetText(self, text):
        Tokens = list(filter(None, re.split('\:|\.', text)))
        if (4 <= len(Tokens)):
            self.Hours = int(Tokens[0])
            self.Minutes = int(Tokens[1])
            self.Seconds = int(Tokens[2])
            self.Millis = int(Tokens[3])
        else:
            self.Hours = int(text[0:2])
            self.Minutes = int(text[2:4])
            self.Seconds = int(text[4:6])
            self.Millis = 0
    #
#
class CUInt32(CObservable):
    #
    def __init__(self, name, value=0, unit=''):
        super(CUInt32, self).__init__(name, unit)
        self.Value = value
        self.Unit = unit
    #
    def GetValue(self):
        return self.Value
    #
    def SetText(self, text):
        Tokens = list(filter(None, re.split('\ ', text)))
        if (2 <= len(Tokens)):
            self.Value = int(Tokens[0])
            self.Unit = Tokens[1]    
        if (1 <= len(Tokens)):
            self.Value = int(Tokens[0])
    #
#
class CFloat32(CObservable):
    #
    def __init__(self, name, value=0.0, unit=''):
        super(CFloat32, self).__init__(name)
        self.Value = value
        self.Unit = unit
    #
    def GetValue(self):
        return self.Value
    #
    def SetText(self, text):
        Tokens = list(filter(None, re.split('\ ', text)))
        if (2 <= len(Tokens)):
            self.Value = float(Tokens[0])
            self.Unit = Tokens[1]    
        if (1 <= len(Tokens)):
            self.Value = float(Tokens[0])
    #
#
#----------------------------------------------------------------------
#   Main
#----------------------------------------------------------------------
#
if ('__main__' == __name__):
    #
    print('*** Observable: begin')
    #
    Date = CDate('Date')#, 21, 11, 27)
    Date.SetText('26.11.2021')
    print(Date.GetDay(), Date.GetMonth(), Date.GetYear())
    Time = CTime('Time')#, 10, 13, 12, 101)
    Time.SetText('19:41:09.123')
    print(Time.GetHours(), Time.GetMinutes(), Time.GetSeconds(), Time.GetMillis())
    Longitude = CFloat32('Longitude', 51.987, 'deg')
    Longitude.SetText('1.234 rad')
    print(Longitude.GetValue())
    #
    print('*** Observable: end')
    #
#

    