#
#----------------------------------------------------------------------
#   PcLRSMeasurement
#----------------------------------------------------------------------
import sys
import serial
import serial.tools.list_ports
#
import random as RND
import numpy as NP
import tkinter as TKI
from time import sleep as Sleep
#
import FrameMain as FM
import Thread as THR
import Uart as UT # conda|pip install pyserial
import ConverterGPSLRS as CVT
#
global VXCycleCount
VXCycleCount = []
global VYFIC00, VYFIC08, VYFIC16, VYFIC24
VYFIC00 = []
VYFIC08 = []
VYFIC16 = []
VYFIC24 = []
global VYFIH00, VYFIH08, VYFIH16, VYFIH24
VYFIH00 = []
VYFIH08 = []
VYFIH16 = []
VYFIH24 = []
global VYFIA00, VYFIA08, VYFIA16, VYFIA24
VYFIA00 = []
VYFIA08 = []
VYFIA16 = []
VYFIA24 = []
global VYHKC00, VYHKH00, VYHKA00
VYHKC00 = []
VYHKH00 = []
VYHKA00 = []
#
Time = 0.0
#
#------------------------------------------------
#   Global - Callback
#------------------------------------------------
# Callback - Uart
def UartOnReadData(id, thread):
    try:
        if not(UartEsp32.GetIsOpened()):
            print('Error: Uart not opened!')
            return
        Sleep(5.000) # necessary: waiting for Uart ready!
        while (thread.IsBusy()):
            RxLine = UartEsp32.ReadLine().rstrip('\r\n')
            if (3 < len(RxLine)):
                # debug print(RxLine)
                MainWindow.OnInfo(RxLine)
                Converter.InterpreteRxLine(RxLine)
            Sleep(.010)
    except:
        return
#
# Callback - GPS
def OnGPSRefreshDateTime(date, time):
    global ResetPlot, VXCycleCount, VYFIC00 #, VYFIC08, VYFIC16, VYFIC24
    try:
        MainWindow.FValues.lblGPSDateN['text'] = date.GetName()
        Text = '{:02}.{:02}.{:4}'.format(date.GetDay(), \
                                         date.GetMonth(), date.GetYear())
        MainWindow.FValues.lblGPSDateV['text'] = Text
        #
        MainWindow.FValues.lblGPSTimeN['text'] = time.GetName()
        Text = '{:02}:{:02}:{:02}.{:03}'.format(time.GetHours(), \
                        time.GetMinutes(), time.GetSeconds(), time.GetMillis())
        MainWindow.FValues.lblGPSTimeV['text'] = Text
    except:
        return
def OnGPSRefreshLocation(latitude, longitude, altitude):
    global ResetPlot, VXCycleCount, VYFIC00, VYFIC08, VYFIC16, VYFIC24
    try:
        MainWindow.FValues.lblGPSLatitudeN['text'] = latitude.GetName()
        MainWindow.FValues.lblGPSLatitudeV['text'] = latitude.GetValue()
        MainWindow.FValues.lblGPSLatitudeU['text'] = latitude.GetUnit()
        #    
        MainWindow.FValues.lblGPSLongitudeN['text'] = longitude.GetName()
        MainWindow.FValues.lblGPSLongitudeV['text'] = longitude.GetValue()
        MainWindow.FValues.lblGPSLongitudeU['text'] = longitude.GetUnit()
        #    
        MainWindow.FValues.lblGPSAltitudeN['text'] = altitude.GetName()
        MainWindow.FValues.lblGPSAltitudeV['text'] = altitude.GetValue()
        MainWindow.FValues.lblGPSAltitudeU['text'] = altitude.GetUnit()
    except:
        return
def OnGPSRefreshQuality(satellites, precision, \
                        characters, good, errors):
    try:
        MainWindow.FValues.lblGPSSatellitesN['text'] = satellites.GetName()
        MainWindow.FValues.lblGPSSatellitesV['text'] = satellites.GetValue()
        #
        MainWindow.FValues.lblGPSPrecisionN['text'] = precision.GetName()
        MainWindow.FValues.lblGPSPrecisionV['text'] = precision.GetValue()
        #
        MainWindow.FValues.lblGPSCharactersN['text'] = characters.GetName()
        MainWindow.FValues.lblGPSCharactersV['text'] = characters.GetValue()
        #
        MainWindow.FValues.lblGPSGoodN['text'] = good.GetName()
        MainWindow.FValues.lblGPSGoodV['text'] = good.GetValue()
        #
        MainWindow.FValues.lblGPSErrorsN['text'] = errors.GetName()
        MainWindow.FValues.lblGPSErrorsV['text'] = errors.GetValue()
    except:
        return
#
# Callback - LRS
def OnLRSRefreshHeader(name, date, time, cyclecount, \
                       zenithangle, cycletime, tcold, thot):
    global VXCycleCount
    try:
        MainWindow.FValues.lblLRSNameN['text'] = name.GetName()
        MainWindow.FValues.lblLRSNameV['text'] = name.GetValue()
        #
        MainWindow.FValues.lblLRSDateN['text'] = date.GetName()
        Text = '{}.{}.{}'.format(date.GetDay(), \
                                  date.GetMonth(), date.GetYear())
        MainWindow.FValues.lblLRSDateV['text'] = Text
        #
        MainWindow.FValues.lblLRSTimeN['text'] = time.GetName()
        Text = '{:02}:{:02}:{:02}.{:03}'.format(time.GetHours(), 
                          time.GetMinutes(), time.GetSeconds(), time.GetMillis())
        MainWindow.FValues.lblLRSTimeV['text'] = Text
        #
        MainWindow.FValues.lblLRSCycleCountN['text'] = cyclecount.GetName()
        MainWindow.FValues.lblLRSCycleCountV['text'] = cyclecount.GetValue()
        if (0 < len(VXCycleCount)):
            if (cyclecount.GetValue() < VXCycleCount[-1]):
                VXCycleCount.clear()
                VYFIC00.clear()
                VYFIC08.clear()
                VYFIC16.clear()
                VYFIC24.clear()
                VYFIH00.clear()
                VYFIH08.clear()
                VYFIH16.clear()
                VYFIH24.clear()
                VYFIA00.clear()
                VYFIA08.clear()
                VYFIA16.clear()
                VYFIA24.clear()
                VYHKC00.clear()
                VYHKH00.clear()
                VYHKA00.clear()        
        VXCycleCount.append(int(cyclecount.GetValue()))
        # 
        MainWindow.FValues.lblLRSZenithAngleN['text'] = zenithangle.GetName()    
        MainWindow.FValues.lblLRSZenithAngleV['text'] = zenithangle.GetValue()
        MainWindow.FValues.lblLRSZenithAngleU['text'] = 'deg' #zenithangle.GetUnit()
        #
        MainWindow.FValues.lblLRSCycleTimeN['text'] = cycletime.GetName()    
        MainWindow.FValues.lblLRSCycleTimeV['text'] = cycletime.GetValue()
        MainWindow.FValues.lblLRSCycleTimeU['text'] = 'ms' #cycletime.GetUnit()
    except:
        return
def OnLRSRefreshFI00C(fic):
    global VYFIC00
    try:
        MainWindow.FValues.lblLRSFIC00N['text'] = 'FI00C' #fic[0].GetName()    
        MainWindow.FValues.lblLRSFIC00V['text'] = fic[0].GetValue()
        VYFIC00.append(int(fic[0].GetValue()))
        #
        MainWindow.FValues.lblLRSFIC01N['text'] = 'FI01C' #fic[1].GetName()    
        MainWindow.FValues.lblLRSFIC01V['text'] = fic[1].GetValue()
        #
        MainWindow.FValues.lblLRSFIC02N['text'] = 'FI02C' #fic[2].GetName()    
        MainWindow.FValues.lblLRSFIC02V['text'] = fic[2].GetValue()
        #
        MainWindow.FValues.lblLRSFIC03N['text'] = 'FI03C' #fic[3].GetName()    
        MainWindow.FValues.lblLRSFIC03V['text'] = fic[3].GetValue()
        #
        MainWindow.FValues.lblLRSFIC04N['text'] = 'FI04C' #fic[4].GetName()    
        MainWindow.FValues.lblLRSFIC04V['text'] = fic[4].GetValue()
        #
        MainWindow.FValues.lblLRSFIC05N['text'] = 'FI05C' #fic[5].GetName()    
        MainWindow.FValues.lblLRSFIC05V['text'] = fic[5].GetValue()
        #
        MainWindow.FValues.lblLRSFIC06N['text'] = 'FI06C' #fic[6].GetName()    
        MainWindow.FValues.lblLRSFIC06V['text'] = fic[6].GetValue()
        #
        MainWindow.FValues.lblLRSFIC07N['text'] = 'FI07C' #fic[7].GetName()    
        MainWindow.FValues.lblLRSFIC07V['text'] = fic[7].GetValue()
    except:
        return
def OnLRSRefreshFI08C(fic):
    global VYFIC08
    try:
        MainWindow.FValues.lblLRSFIC08N['text'] = 'FI08C' 
        MainWindow.FValues.lblLRSFIC08V['text'] = fic[8].GetValue()
        VYFIC08.append(int(fic[8].GetValue()))
        #
        MainWindow.FValues.lblLRSFIC09N['text'] = 'FI09C' 
        MainWindow.FValues.lblLRSFIC09V['text'] = fic[9].GetValue()
        #
        MainWindow.FValues.lblLRSFIC10N['text'] = 'FI10C' 
        MainWindow.FValues.lblLRSFIC10V['text'] = fic[10].GetValue()
        #
        MainWindow.FValues.lblLRSFIC11N['text'] = 'FI11C' 
        MainWindow.FValues.lblLRSFIC11V['text'] = fic[11].GetValue()
        #
        MainWindow.FValues.lblLRSFIC12N['text'] = 'FI12C' 
        MainWindow.FValues.lblLRSFIC12V['text'] = fic[12].GetValue()
        #
        MainWindow.FValues.lblLRSFIC13N['text'] = 'FI13C' 
        MainWindow.FValues.lblLRSFIC13V['text'] = fic[13].GetValue()
        #
        MainWindow.FValues.lblLRSFIC14N['text'] = 'FI14C' 
        MainWindow.FValues.lblLRSFIC14V['text'] = fic[14].GetValue()
        #
        MainWindow.FValues.lblLRSFIC15N['text'] = 'FI15C' 
        MainWindow.FValues.lblLRSFIC15V['text'] = fic[15].GetValue()
    except:
        return
def OnLRSRefreshFI16C(fic):
    global VYFIC16
    try:
        MainWindow.FValues.lblLRSFIC16N['text'] = 'FI16C' 
        MainWindow.FValues.lblLRSFIC16V['text'] = fic[16].GetValue()
        VYFIC16.append(int(fic[16].GetValue()))
        #
        MainWindow.FValues.lblLRSFIC17N['text'] = 'FI17C' 
        MainWindow.FValues.lblLRSFIC17V['text'] = fic[17].GetValue()
        #
        MainWindow.FValues.lblLRSFIC18N['text'] = 'FI18C' 
        MainWindow.FValues.lblLRSFIC18V['text'] = fic[18].GetValue()
        #
        MainWindow.FValues.lblLRSFIC19N['text'] = 'FI19C' 
        MainWindow.FValues.lblLRSFIC19V['text'] = fic[19].GetValue()
        #
        MainWindow.FValues.lblLRSFIC20N['text'] = 'FI20C' 
        MainWindow.FValues.lblLRSFIC20V['text'] = fic[20].GetValue()
        #
        MainWindow.FValues.lblLRSFIC21N['text'] = 'FI21C' 
        MainWindow.FValues.lblLRSFIC21V['text'] = fic[21].GetValue()
        #
        MainWindow.FValues.lblLRSFIC22N['text'] = 'FI22C' 
        MainWindow.FValues.lblLRSFIC22V['text'] = fic[22].GetValue()
        #
        MainWindow.FValues.lblLRSFIC23N['text'] = 'FI23C' 
        MainWindow.FValues.lblLRSFIC23V['text'] = fic[23].GetValue()
    except:
        return
def OnLRSRefreshFI24C(fic):
    global VYFIC24
    try:
        MainWindow.FValues.lblLRSFIC24N['text'] = 'FI24C' 
        MainWindow.FValues.lblLRSFIC24V['text'] = fic[24].GetValue()
        VYFIC24.append(int(fic[24].GetValue()))
        #
        MainWindow.FValues.lblLRSFIC25N['text'] = 'FI25C' 
        MainWindow.FValues.lblLRSFIC25V['text'] = fic[25].GetValue()
        #
        MainWindow.FValues.lblLRSFIC26N['text'] = 'FI26C' 
        MainWindow.FValues.lblLRSFIC26V['text'] = fic[26].GetValue()
        #
        MainWindow.FValues.lblLRSFIC27N['text'] = 'FI27C' 
        MainWindow.FValues.lblLRSFIC27V['text'] = fic[27].GetValue()
        #
        MainWindow.FValues.lblLRSFIC28N['text'] = 'FI28C' 
        MainWindow.FValues.lblLRSFIC28V['text'] = fic[28].GetValue()
        #
        MainWindow.FValues.lblLRSFIC29N['text'] = 'FI29C' 
        MainWindow.FValues.lblLRSFIC29V['text'] = fic[29].GetValue()
        #
        MainWindow.FValues.lblLRSFIC30N['text'] = 'FI30C' 
        MainWindow.FValues.lblLRSFIC30V['text'] = fic[30].GetValue()
        #
        MainWindow.FValues.lblLRSFIC31N['text'] = 'FI31C' 
        MainWindow.FValues.lblLRSFIC31V['text'] = fic[31].GetValue()
    except:
        return
def OnLRSRefreshFI00H(fih):
    global VYFIH00
    try:
        MainWindow.FValues.lblLRSFIH00N['text'] = 'FI00H'
        MainWindow.FValues.lblLRSFIH00V['text'] = fih[0].GetValue()
        VYFIH00.append(int(fih[0].GetValue()))
        #
        MainWindow.FValues.lblLRSFIH01N['text'] = 'FI01H'
        MainWindow.FValues.lblLRSFIH01V['text'] = fih[1].GetValue()
        #
        MainWindow.FValues.lblLRSFIH02N['text'] = 'FI02H'
        MainWindow.FValues.lblLRSFIH02V['text'] = fih[2].GetValue()
        #
        MainWindow.FValues.lblLRSFIH03N['text'] = 'FI03H'
        MainWindow.FValues.lblLRSFIH03V['text'] = fih[3].GetValue()
        #
        MainWindow.FValues.lblLRSFIH04N['text'] = 'FI04H'
        MainWindow.FValues.lblLRSFIH04V['text'] = fih[4].GetValue()
        #
        MainWindow.FValues.lblLRSFIH05N['text'] = 'FI05H'
        MainWindow.FValues.lblLRSFIH05V['text'] = fih[5].GetValue()
        #
        MainWindow.FValues.lblLRSFIH06N['text'] = 'FI06H'
        MainWindow.FValues.lblLRSFIH06V['text'] = fih[6].GetValue()
        #
        MainWindow.FValues.lblLRSFIH07N['text'] = 'FI07H'
        MainWindow.FValues.lblLRSFIH07V['text'] = fih[7].GetValue()
    except:
        return
def OnLRSRefreshFI08H(fih):
    global VYFIH08
    try:
        MainWindow.FValues.lblLRSFIH08N['text'] = 'FI08H' 
        MainWindow.FValues.lblLRSFIH08V['text'] = fih[8].GetValue()
        VYFIH08.append(int(fih[8].GetValue()))
        #
        MainWindow.FValues.lblLRSFIH09N['text'] = 'FI09H' 
        MainWindow.FValues.lblLRSFIH09V['text'] = fih[9].GetValue()
        #
        MainWindow.FValues.lblLRSFIH10N['text'] = 'FI10H' 
        MainWindow.FValues.lblLRSFIH10V['text'] = fih[10].GetValue()
        #
        MainWindow.FValues.lblLRSFIH11N['text'] = 'FI11H' 
        MainWindow.FValues.lblLRSFIH11V['text'] = fih[11].GetValue()
        #
        MainWindow.FValues.lblLRSFIH12N['text'] = 'FI12H' 
        MainWindow.FValues.lblLRSFIH12V['text'] = fih[12].GetValue()
        #
        MainWindow.FValues.lblLRSFIH13N['text'] = 'FI13H' 
        MainWindow.FValues.lblLRSFIH13V['text'] = fih[13].GetValue()
        #
        MainWindow.FValues.lblLRSFIH14N['text'] = 'FI14H' 
        MainWindow.FValues.lblLRSFIH14V['text'] = fih[14].GetValue()
        #
        MainWindow.FValues.lblLRSFIH15N['text'] = 'FI15H' 
        MainWindow.FValues.lblLRSFIH15V['text'] = fih[15].GetValue()
    except:
        return
def OnLRSRefreshFI16H(fih):
    global VYFIH16
    try:
        MainWindow.FValues.lblLRSFIH16N['text'] = 'FI16H' 
        MainWindow.FValues.lblLRSFIH16V['text'] = fih[16].GetValue()
        VYFIH16.append(int(fih[16].GetValue()))
        #
        MainWindow.FValues.lblLRSFIH17N['text'] = 'FI17H' 
        MainWindow.FValues.lblLRSFIH17V['text'] = fih[17].GetValue()
        #
        MainWindow.FValues.lblLRSFIH18N['text'] = 'FI18H' 
        MainWindow.FValues.lblLRSFIH18V['text'] = fih[18].GetValue()
        #
        MainWindow.FValues.lblLRSFIH19N['text'] = 'FI19H' 
        MainWindow.FValues.lblLRSFIH19V['text'] = fih[19].GetValue()
        #
        MainWindow.FValues.lblLRSFIH20N['text'] = 'FI20H' 
        MainWindow.FValues.lblLRSFIH20V['text'] = fih[20].GetValue()
        #
        MainWindow.FValues.lblLRSFIH21N['text'] = 'FI21H' 
        MainWindow.FValues.lblLRSFIH21V['text'] = fih[21].GetValue()
        #
        MainWindow.FValues.lblLRSFIH22N['text'] = 'FI22H' 
        MainWindow.FValues.lblLRSFIH22V['text'] = fih[22].GetValue()
        #
        MainWindow.FValues.lblLRSFIH23N['text'] = 'FI23H' 
        MainWindow.FValues.lblLRSFIH23V['text'] = fih[23].GetValue()
    except:
        return
def OnLRSRefreshFI24H(fih):
    global VYFIH24
    try:
        MainWindow.FValues.lblLRSFIH24N['text'] = 'FI24H' 
        MainWindow.FValues.lblLRSFIH24V['text'] = fih[24].GetValue()
        VYFIH24.append(int(fih[24].GetValue()))
        #
        MainWindow.FValues.lblLRSFIH25N['text'] = 'FI25H' 
        MainWindow.FValues.lblLRSFIH25V['text'] = fih[25].GetValue()
        #
        MainWindow.FValues.lblLRSFIH26N['text'] = 'FI26H' 
        MainWindow.FValues.lblLRSFIH26V['text'] = fih[26].GetValue()
        #
        MainWindow.FValues.lblLRSFIH27N['text'] = 'FI27H' 
        MainWindow.FValues.lblLRSFIH27V['text'] = fih[27].GetValue()
        #
        MainWindow.FValues.lblLRSFIH28N['text'] = 'FI28H' 
        MainWindow.FValues.lblLRSFIH28V['text'] = fih[28].GetValue()
        #
        MainWindow.FValues.lblLRSFIH29N['text'] = 'FI29H' 
        MainWindow.FValues.lblLRSFIH29V['text'] = fih[29].GetValue()
        #
        MainWindow.FValues.lblLRSFIH30N['text'] = 'FI30H' 
        MainWindow.FValues.lblLRSFIH30V['text'] = fih[30].GetValue()
        #
        MainWindow.FValues.lblLRSFIH31N['text'] = 'FI31H' 
        MainWindow.FValues.lblLRSFIH31V['text'] = fih[31].GetValue()
    except:
        return
def OnLRSRefreshFI00A(fia):
    global VYFIA00
    try:
        MainWindow.FValues.lblLRSFIA00N['text'] = 'FI00A'
        MainWindow.FValues.lblLRSFIA00V['text'] = fia[0].GetValue()
        VYFIA00.append(int(fia[0].GetValue()))
        #
        MainWindow.FValues.lblLRSFIA01N['text'] = 'FI01A'
        MainWindow.FValues.lblLRSFIA01V['text'] = fia[1].GetValue()
        #
        MainWindow.FValues.lblLRSFIA02N['text'] = 'FI02A'
        MainWindow.FValues.lblLRSFIA02V['text'] = fia[2].GetValue()
        #
        MainWindow.FValues.lblLRSFIA03N['text'] = 'FI03A'
        MainWindow.FValues.lblLRSFIA03V['text'] = fia[3].GetValue()
        #
        MainWindow.FValues.lblLRSFIA04N['text'] = 'FI04A'
        MainWindow.FValues.lblLRSFIA04V['text'] = fia[4].GetValue()
        #
        MainWindow.FValues.lblLRSFIA05N['text'] = 'FI05A'
        MainWindow.FValues.lblLRSFIA05V['text'] = fia[5].GetValue()
        #
        MainWindow.FValues.lblLRSFIA06N['text'] = 'FI06A'
        MainWindow.FValues.lblLRSFIA06V['text'] = fia[6].GetValue()
        #
        MainWindow.FValues.lblLRSFIA07N['text'] = 'FI07A'
        MainWindow.FValues.lblLRSFIA07V['text'] = fia[7].GetValue()
    except:
        return
def OnLRSRefreshFI08A(fia):
    global VYFIA08
    try:
        MainWindow.FValues.lblLRSFIA08N['text'] = 'FI08A' 
        MainWindow.FValues.lblLRSFIA08V['text'] = fia[8].GetValue()
        VYFIA08.append(int(fia[8].GetValue()))
        #
        MainWindow.FValues.lblLRSFIA09N['text'] = 'FI09A' 
        MainWindow.FValues.lblLRSFIA09V['text'] = fia[9].GetValue()
        #
        MainWindow.FValues.lblLRSFIA10N['text'] = 'FI10A' 
        MainWindow.FValues.lblLRSFIA10V['text'] = fia[10].GetValue()
        #
        MainWindow.FValues.lblLRSFIA11N['text'] = 'FI11A' 
        MainWindow.FValues.lblLRSFIA11V['text'] = fia[11].GetValue()
        #
        MainWindow.FValues.lblLRSFIA12N['text'] = 'FI12A' 
        MainWindow.FValues.lblLRSFIA12V['text'] = fia[12].GetValue()
        #
        MainWindow.FValues.lblLRSFIA13N['text'] = 'FI13A' 
        MainWindow.FValues.lblLRSFIA13V['text'] = fia[13].GetValue()
        #
        MainWindow.FValues.lblLRSFIA14N['text'] = 'FI14A' 
        MainWindow.FValues.lblLRSFIA14V['text'] = fia[14].GetValue()
        #
        MainWindow.FValues.lblLRSFIA15N['text'] = 'FI15A' 
        MainWindow.FValues.lblLRSFIA15V['text'] = fia[15].GetValue()
    except:
        return
def OnLRSRefreshFI16A(fia):
    global VYFIA16
    try:
        MainWindow.FValues.lblLRSFIA16N['text'] = 'FI16A' 
        MainWindow.FValues.lblLRSFIA16V['text'] = fia[16].GetValue()
        VYFIA16.append(int(fia[16].GetValue()))
        #
        MainWindow.FValues.lblLRSFIA17N['text'] = 'FI17A' 
        MainWindow.FValues.lblLRSFIA17V['text'] = fia[17].GetValue()
        #
        MainWindow.FValues.lblLRSFIA18N['text'] = 'FI18A' 
        MainWindow.FValues.lblLRSFIA18V['text'] = fia[18].GetValue()
        #
        MainWindow.FValues.lblLRSFIA19N['text'] = 'FI19A' 
        MainWindow.FValues.lblLRSFIA19V['text'] = fia[19].GetValue()
        #
        MainWindow.FValues.lblLRSFIA20N['text'] = 'FI20A' 
        MainWindow.FValues.lblLRSFIA20V['text'] = fia[20].GetValue()
        #
        MainWindow.FValues.lblLRSFIA21N['text'] = 'FI21A' 
        MainWindow.FValues.lblLRSFIA21V['text'] = fia[21].GetValue()
        #
        MainWindow.FValues.lblLRSFIA22N['text'] = 'FI22A' 
        MainWindow.FValues.lblLRSFIA22V['text'] = fia[22].GetValue()
        #
        MainWindow.FValues.lblLRSFIA23N['text'] = 'FI23A' 
        MainWindow.FValues.lblLRSFIA23V['text'] = fia[23].GetValue()
    except:
        return
def OnLRSRefreshFI24A(fia):
    global VYFIA24
    try:
        MainWindow.FValues.lblLRSFIA24N['text'] = 'FI24A' 
        MainWindow.FValues.lblLRSFIA24V['text'] = fia[24].GetValue()
        VYFIA24.append(int(fia[24].GetValue()))
        #
        MainWindow.FValues.lblLRSFIA25N['text'] = 'FI25A' 
        MainWindow.FValues.lblLRSFIA25V['text'] = fia[25].GetValue()
        #
        MainWindow.FValues.lblLRSFIA26N['text'] = 'FI26A' 
        MainWindow.FValues.lblLRSFIA26V['text'] = fia[26].GetValue()
        #
        MainWindow.FValues.lblLRSFIA27N['text'] = 'FI27A' 
        MainWindow.FValues.lblLRSFIA27V['text'] = fia[27].GetValue()
        #
        MainWindow.FValues.lblLRSFIA28N['text'] = 'FI28A' 
        MainWindow.FValues.lblLRSFIA28V['text'] = fia[28].GetValue()
        #
        MainWindow.FValues.lblLRSFIA29N['text'] = 'FI29A' 
        MainWindow.FValues.lblLRSFIA29V['text'] = fia[29].GetValue()
        #
        MainWindow.FValues.lblLRSFIA30N['text'] = 'FI30A' 
        MainWindow.FValues.lblLRSFIA30V['text'] = fia[30].GetValue()
        #
        MainWindow.FValues.lblLRSFIA31N['text'] = 'FI31A' 
        MainWindow.FValues.lblLRSFIA31V['text'] = fia[31].GetValue()
    except:
        return
def OnLRSRefreshHK00C(hkc):
    global VYHKC00
    try:
        MainWindow.FValues.lblLRSHKC00N['text'] = 'HK00A'
        MainWindow.FValues.lblLRSHKC00V['text'] = hkc[0].GetValue()
        VYHKC00.append(int(hkc[0].GetValue()))
        #
        MainWindow.FValues.lblLRSHKC01N['text'] = 'HK01A'
        MainWindow.FValues.lblLRSHKC01V['text'] = hkc[1].GetValue()
        #
        MainWindow.FValues.lblLRSHKC02N['text'] = 'HK02A'
        MainWindow.FValues.lblLRSHKC02V['text'] = hkc[2].GetValue()
        #
        MainWindow.FValues.lblLRSHKC03N['text'] = 'HK03A'
        MainWindow.FValues.lblLRSHKC03V['text'] = hkc[3].GetValue()
        #
        MainWindow.FValues.lblLRSHKC04N['text'] = 'HK04A'
        MainWindow.FValues.lblLRSHKC04V['text'] = hkc[4].GetValue()
        #
        MainWindow.FValues.lblLRSHKC05N['text'] = 'HK05A'
        MainWindow.FValues.lblLRSHKC05V['text'] = hkc[5].GetValue()
        #
        MainWindow.FValues.lblLRSHKC06N['text'] = 'HK06A'
        MainWindow.FValues.lblLRSHKC06V['text'] = hkc[6].GetValue()
        #
        MainWindow.FValues.lblLRSHKC07N['text'] = 'HK07A'
        MainWindow.FValues.lblLRSHKC07V['text'] = hkc[7].GetValue()
    except:
        return
def OnLRSRefreshHK00H(hkh):
    global VYHKH00
    #
    try:    
        MainWindow.FValues.lblLRSHKH00N['text'] = 'HK00H'
        MainWindow.FValues.lblLRSHKH00V['text'] = hkh[0].GetValue()
        VYHKH00.append(int(hkh[0].GetValue()))
        #
        MainWindow.FValues.lblLRSHKH01N['text'] = 'HK01H'
        MainWindow.FValues.lblLRSHKH01V['text'] = hkh[1].GetValue()
        #
        MainWindow.FValues.lblLRSHKH02N['text'] = 'HK02H'
        MainWindow.FValues.lblLRSHKH02V['text'] = hkh[2].GetValue()
        #
        MainWindow.FValues.lblLRSHKH03N['text'] = 'HK03H'
        MainWindow.FValues.lblLRSHKH03V['text'] = hkh[3].GetValue()
        #
        MainWindow.FValues.lblLRSHKH04N['text'] = 'HK04H'
        MainWindow.FValues.lblLRSHKH04V['text'] = hkh[4].GetValue()
        #
        MainWindow.FValues.lblLRSHKH05N['text'] = 'HK05H'
        MainWindow.FValues.lblLRSHKH05V['text'] = hkh[5].GetValue()
        #
        MainWindow.FValues.lblLRSHKH06N['text'] = 'HK06H'
        MainWindow.FValues.lblLRSHKH06V['text'] = hkh[6].GetValue()
        #
        MainWindow.FValues.lblLRSHKH07N['text'] = 'HK07H'
        MainWindow.FValues.lblLRSHKH07V['text'] = hkh[7].GetValue()
    except:
        return
def OnLRSRefreshHK00A(hka):
    global VYHKA00
    try:
        MainWindow.FValues.lblLRSHKA00N['text'] = 'HK00A'
        MainWindow.FValues.lblLRSHKA00V['text'] = hka[0].GetValue()
        VYHKA00.append(int(hka[0].GetValue()))
        #
        MainWindow.FValues.lblLRSHKA01N['text'] = 'HK01A'
        MainWindow.FValues.lblLRSHKA01V['text'] = hka[1].GetValue()
        #
        MainWindow.FValues.lblLRSHKA02N['text'] = 'HK02A'
        MainWindow.FValues.lblLRSHKA02V['text'] = hka[2].GetValue()
        #
        MainWindow.FValues.lblLRSHKA03N['text'] = 'HK03A'
        MainWindow.FValues.lblLRSHKA03V['text'] = hka[3].GetValue()
        #
        MainWindow.FValues.lblLRSHKA04N['text'] = 'HK04A'
        MainWindow.FValues.lblLRSHKA04V['text'] = hka[4].GetValue()
        #
        MainWindow.FValues.lblLRSHKA05N['text'] = 'HK05A'
        MainWindow.FValues.lblLRSHKA05V['text'] = hka[5].GetValue()
        #
        MainWindow.FValues.lblLRSHKA06N['text'] = 'HK06A'
        MainWindow.FValues.lblLRSHKA06V['text'] = hka[6].GetValue()
        #
        MainWindow.FValues.lblLRSHKA07N['text'] = 'HK07A'
        MainWindow.FValues.lblLRSHKA07V['text'] = hka[7].GetValue()
        #
        if (40 <= len(VXCycleCount)):
            del VXCycleCount[0]
            del VYFIC00[0]
            del VYFIC08[0]
            del VYFIC16[0]
            del VYFIC24[0]
            del VYFIH00[0]
            del VYFIH08[0]
            del VYFIH16[0]
            del VYFIH24[0]
            del VYFIA00[0]
            del VYFIA08[0]
            del VYFIA16[0]
            del VYFIA24[0]
            del VYHKC00[0]
            del VYHKH00[0]
            del VYHKA00[0]
        if (0 < len(VYHKA00)):
            MainWindow.Plot.Refresh(VXCycleCount, 
                                    VYFIC00, VYFIC08, VYFIC16, VYFIC24,
                                    VYFIH00, VYFIH08, VYFIH16, VYFIH24,
                                    VYFIA00, VYFIA08, VYFIA16, VYFIA24,
                                    VYHKC00, VYHKH00, VYHKA00)
    except:
        return
#
#
#------------------------------------------------
#   Global - Field 
#------------------------------------------------
UartEsp32 = UT.CUart('UartEsp32')
ThreadValues = THR.CThread('ThreadValues', UartOnReadData)
Converter = CVT.CConverterGPSLRS()
Converter.SetOnGPSRefreshDateTime(OnGPSRefreshDateTime)
Converter.SetOnGPSRefreshLocation(OnGPSRefreshLocation)
Converter.SetOnGPSRefreshQuality(OnGPSRefreshQuality)
Converter.SetOnLRSRefreshHeader(OnLRSRefreshHeader)
Converter.SetOnLRSRefreshFI00C(OnLRSRefreshFI00C)
Converter.SetOnLRSRefreshFI08C(OnLRSRefreshFI08C)
Converter.SetOnLRSRefreshFI16C(OnLRSRefreshFI16C)
Converter.SetOnLRSRefreshFI24C(OnLRSRefreshFI24C)
Converter.SetOnLRSRefreshFI00H(OnLRSRefreshFI00H)
Converter.SetOnLRSRefreshFI08H(OnLRSRefreshFI08H)
Converter.SetOnLRSRefreshFI16H(OnLRSRefreshFI16H)
Converter.SetOnLRSRefreshFI24H(OnLRSRefreshFI24H)
Converter.SetOnLRSRefreshFI00A(OnLRSRefreshFI00A)
Converter.SetOnLRSRefreshFI08A(OnLRSRefreshFI08A)
Converter.SetOnLRSRefreshFI16A(OnLRSRefreshFI16A)
Converter.SetOnLRSRefreshFI24A(OnLRSRefreshFI24A)
Converter.SetOnLRSRefreshFI00A(OnLRSRefreshFI00A)
Converter.SetOnLRSRefreshFI08A(OnLRSRefreshFI08A)
Converter.SetOnLRSRefreshFI16A(OnLRSRefreshFI16A)
Converter.SetOnLRSRefreshFI24A(OnLRSRefreshFI24A)
Converter.SetOnLRSRefreshHK00C(OnLRSRefreshHK00C)
Converter.SetOnLRSRefreshHK00H(OnLRSRefreshHK00H)
Converter.SetOnLRSRefreshHK00A(OnLRSRefreshHK00A)
#
#------------------------------------------------
#   Global - Function
#------------------------------------------------
def InitialiseUart():    
    ComPortsAvailable = UartEsp32.GetAvailableComPorts()
    print('------------------------')
    print('List of available ComPorts:')
    for CP in ComPortsAvailable:
        if ((None != CP.pid) and (None != CP.vid)):
            print('  Name[{}] Description[{}]'.format(CP.name, CP.description))
    print('------------------------')
    if (0 < len(ComPortsAvailable)):
        CP = ComPortsAvailable[0]
        try:
            UartEsp32.Open('UartEsp32', CP.name)
        except:
            UartEsp32.Close()
            print('Error: Cannot open ComPort[{}]!'.format(CP.name))
            sys.exit()
            return False
    return True
#
def InitialiseThread():    
    ThreadValues.Start()    

#
#----------------------------------------------------------------------
#   Main
#----------------------------------------------------------------------
if ('__main__' == __name__):
    print('*** PcLRSMeasurement: begin')
    #
    try:
        InitialiseUart()
        InitialiseThread()
        #
        MainWindow = FM.CFrameMain(TKI.Tk()) #, PERIOD_REFRESHPLOT) #, \
                                   #TIME_START, TIME_PERIOD, \
                                   #-AMPLITUDE_FIXED, +AMPLITUDE_FIXED)
        #MainWindow.Plot.SetOnRefreshValues(OnRefreshValues)
        MainWindow.Execute();
    finally:
        ThreadValues.Abort()
        UartEsp32.Close()
        # ThreadValues.WaitForEnd()
    #
    print('*** PcLRSMeasurement: end')
#-------------------------------------------------------------------
    
    
    
    
    
    
  