#
#----------------------------------------------------------------------
#   FrameMain
#----------------------------------------------------------------------
import tkinter as TKI
from tkinter import ttk as TTK
#
import FramePlot as FP
import FrameValues as FV
#
#----------------------------------------------------------------------
class CFrameMain():
    #
    BORDER_X = 2
    BORDER_Y = 3
    #
    def __init__(self, tk): #, periodrefresh): #, xl, xh, yl, yh):
        self.TK = tk        
        self.TK.title("PcLoidlRadioSpectrometer")
        WW = 1074
        WH = 890                    
        WX = 60 # -WW - 32 # 60
        WY = +60
        self.TK.geometry('%dx%d+%d+%d' % (WW, WH, WX, WY))
        self.TK.rowconfigure(index=0, weight=0)
        self.TK.rowconfigure(index=1, weight=1) # 1 Plot!
        self.TK.rowconfigure(index=2, weight=0) # 1 Plot!
        self.TK.columnconfigure(index=0, weight=1) # 1 Plot!
        #self.TK.columnconfigure(index=1, weight=0)
        #self.TK.columnconfigure(index=2, weight=0)
        #self.TK.columnconfigure(index=3, weight=0)
        # #------------------------------------------------------------
        # Menu
        self.MenuMain = TKI.Menu(self.TK)
        self.TK.config(menu=self.MenuMain)
        self.MenuSystem = TKI.Menu(self.MenuMain, tearoff=0)
        self.MenuMain.add_cascade(label='System', menu=self.MenuSystem)
        self.MenuSystem.add_command(label='New', command=self.OnSystemNew)
        self.MenuSystem.add_separator()
        self.MenuSystem.add_command(label='Quit', command=self.OnSystemQuit)
        #------------------------------------------------------------
        # # Top
        # self.FT = TKI.Frame(self.TK, bg='#888888', padx=1, pady=1)        
        # self.FT.grid(row=0, column=0, sticky='nsew')
        # #
        # self.BA = TKI.Button(self.FT, text="Action A", \
        #                       bg="#DDDDDD", fg="#000000")
        # self.BA.grid(row=0, column=1, sticky='W', \
        #               padx=self.BORDER_X, pady=self.BORDER_Y)
        # self.BB = TKI.Button(self.FT, text="Action B", \
        #                       bg="#DDDDDD", fg="#000000")
        # self.BB.grid(row=0, column=2, sticky='W', \
        #               padx=self.BORDER_X, pady=self.BORDER_Y)
        # self.BC = TKI.Button(self.FT, text="Action C", \
        #                       bg="#DDDDDD", fg="#000000", \
        #                       command=self.OnBCClicked)
        # self.BC.grid(row=0, column=3, sticky='W', \
        #               padx=self.BORDER_X, pady=self.BORDER_Y)
        # self.lblInfo = TKI.Label(self.FT, text="---", \
        #                       bg="#DDDDDD", fg="#000000")
        # self.lblInfo.grid(row=0, column=4, sticky='W', \
        #               padx=self.BORDER_X, pady=self.BORDER_Y)

            
        #------------------------------------------------------------
        self.NB = TTK.Notebook(self.TK)
        # self.NB.pack(pady=10, expand=True)
        self.NB.grid(row=1, column=0, sticky='swne') #rowspan=5, columnspan=5)
        #
        self.TSValues = TKI.Frame(self.NB, width=400, height=280, \
                                  bg='#F0F4FF')
        self.TSValues.pack(fill='both', expand=True)
        #self.TSValues.config(bg='#FFFFFF')
        self.TSPlot = TKI.Frame(self.NB, width=400, height=280, \
                                bg='#F0FFF4')
        self.TSPlot.pack(fill='both', expand=True)
        self.NB.add(self.TSValues, text='Values')
        self.NB.add(self.TSPlot, text='Plot')
        #
        self.FValues = FV.CFrameValues(self.TSValues)
        
       
        #------------------------------------------------------------
        # Plot
        #self.FP = TKI.Frame(self.TK, bg='#AAAAAA', padx=1, pady=1)
        #self.FP.grid(row=1, column=0, columnspan=5, sticky='nesw')
        # #
        self.Plot = FP.CPlot(self.TSPlot) #, periodrefresh) #, xl, xh, yl, yh)
        #self.Plot.grid(row=0, column=0)
        #self.Plot.SetOnInfo(self.OnInfo)
        #------------------------------------------------------------
        # Bottom - Listbox
        self.FB = TKI.Frame(self.TK, bg='#000000', padx=1, pady=1)        
        self.FB.grid(row=3, column=0, sticky='nsew')
        #
        self.SB = TKI.Scrollbar(self.FB)
        self.SB.pack(side='right', fill='y')
        self.LB = TKI.Listbox(self.FB, font='Courier 11')   
        self.LB.pack(fill='both', expand=True) 
        self.LB.config(yscrollcommand=self.SB.set)
        self.SB.config(command=self.LB.yview)
        #
        return
    #
    def OnInfo(self, text):
        try:
            LC = self.LB.size()
            self.LB.insert('end', text)
            self.LB.see('end')
            self.LB.selection_clear('end')
            if (100 < self.LB.size()):
                self.LB.delete(0, self.LB.size() - 20)
        except:
            return
    #
    def OnBCClicked(self):
        self.OnInfo('abc')
        self.Plot.Info('uvw')
    #
    def OnSystemNew(self):
        # ...
        return
    def OnSystemQuit(self):
        self.TK.destroy()
    #
    def Execute(self):
        self.TK.mainloop()
#
#----------------------------------------------------------------------
#   Main
#----------------------------------------------------------------------
# import runpy
# runpy.run_path(path_name='RealTimePlot.py')
# exec(open('RealTimePlot.py').read())
#
if ('__main__' == __name__):
    #
    print('*** FrameMain: begin')
    #
    WindowMain = CFrameMain(TKI.Tk())
    for I in range(0, 100):
        WindowMain.OnInfo(str(I))
    WindowMain.Execute();
    #
    print('*** FrameMain: end')
    #
#
#-----------------------------------------------------
        # notebook = TTK.Notebook(self.TK)
        # notebook.pack(pady=10, expand=True)
        # frame1 = TTK.Frame(notebook, width=400, height=280)
        # frame2 = TTK.Frame(notebook, width=400, height=280)
        # frame1.pack(fill='both', expand=True)
        # frame2.pack(fill='both', expand=True)
        # notebook.add(frame1, text='General Information')
        # notebook.add(frame2, text='Profile')        


