#
#----------------------------------------------------------------------
#   FramePlot
#----------------------------------------------------------------------
import random as RND
import numpy as NP
import matplotlib.pyplot as PLT
import tkinter as TKI
from matplotlib.backends.backend_tkagg \
    import FigureCanvasTkAgg #, NavigationToolbar2Tk
#
LW = 0.7
LCS = [ \
 (0.75, 0.50, 0.25),(0.75, 0.50, 0.25),(0.75, 0.50, 0.25),(0.75, 0.50, 0.25), \
 (0.75, 0.50, 0.25),(0.75, 0.50, 0.25),(0.75, 0.50, 0.25),(0.75, 0.50, 0.25), \
 (0.75, 0.50, 0.25),(0.75, 0.50, 0.25),(0.75, 0.50, 0.25),(0.75, 0.50, 0.25), \
 (0.75, 0.50, 0.25), (0.75, 0.50, 0.25), (0.75, 0.50, 0.25)]
#----------------------------------------------------------------------
class CPlot():
    #
    def __init__(self, parent): #, periodrefresh): #, xl, xh, yl, yh):
        self.Parent = parent
        #self.PeriodRefresh = periodrefresh
        #self.OnRefreshValues = None
        F, A = PLT.subplots(figsize=(6, 4), dpi=100)
        self.Figure = F
        self.Axes = A   
        self.PlotData, = self.Axes.plot([], [])
        #
        self.Canvas = FigureCanvasTkAgg(self.Figure, master=self.Parent)
        #self.Toolbar = NavigationToolbar2Tk(self.Canvas, window)
        self.Canvas.get_tk_widget().pack(side=TKI.TOP, fill=TKI.BOTH, expand=1)
        self.OnInfo = None
        # later on init:
        PLT.grid("both")
        self.XL = +100000
        self.XH = -100000
        #self.YL = yl
        #self.YH = yh
        #self.Axes.set_ylim([self.YL, self.YH])
        # self.VXCycleCount = []
        # self.VYFIC00 = []
        # self.VYFIC08 = []
        # self.VYFIC16 = []
        # self.VYFIC24 = []
        #self.RefreshValues(0)
    #
    def SetOnInfo(self, oninfo):
        self.OnInfo = oninfo
    #
    # def SetOnRefreshValues(self, onrefreshvalues):
    #     self.OnRefreshValues = onrefreshvalues
    #
    def Info(self, text):
        # debug print(text)
        if (None != self.OnInfo):
            self.OnInfo(text)
    #
    def Refresh(self, vxcc, 
                vyfic00, vyfic08, vyfic16, vyfic24,
                vyfih00, vyfih08, vyfih16, vyfih24,
                vyfia00, vyfia08, vyfia16, vyfia24,
                vyhkc00, vyhkh00, vyhka00):
        self.XL = vxcc[0]
        self.XH = 1 + vxcc[-1]
        self.Axes.set_xlim(self.XL, self.XH)
        #self.Axes.set_ylim(-100, +100)
        #
        PLT.plot(vxcc, vyfic00, '-om', linewidth=LW)
        PLT.plot(vxcc, vyfic08, '-og', linewidth=LW)
        PLT.plot(vxcc, vyfic16, '-or', linewidth=LW)
        PLT.plot(vxcc, vyfic24, '-oc', linewidth=LW)
        #
        PLT.plot(vxcc, vyfih00, '-om', linewidth=LW)
        PLT.plot(vxcc, vyfih08, '-og', linewidth=LW)
        PLT.plot(vxcc, vyfih16, '-or', linewidth=LW)
        PLT.plot(vxcc, vyfih24, '-oc', linewidth=LW)
        #
        PLT.plot(vxcc, vyfia00, '-om', linewidth=LW)
        PLT.plot(vxcc, vyfia08, '-og', linewidth=LW)
        PLT.plot(vxcc, vyfia16, '-or', linewidth=LW)
        PLT.plot(vxcc, vyfia24, '-oc', linewidth=LW)
        #
        PLT.plot(vxcc, vyhkc00, '-om', linewidth=LW)
        PLT.plot(vxcc, vyhkh00, '-og', linewidth=LW)
        PLT.plot(vxcc, vyhka00, '-or', linewidth=LW)
        #
        self.Canvas.draw()
        self.Canvas.flush_events()
        return
    #
    # def RefreshValues(self, ticks=0):
    #     try:
    #         ticks += 1
    #         if (None != self.OnRefreshValues):
    #             PlotParameter = self.OnRefreshValues(ticks)#, \
    #                                                   #self.XL, self.XH, \
    #                                                   #self.YL, self.YH)
    #             self.VXCycleCount = PlotParameter[0]
    #             self.VYFIC00 = PlotParameter[1]
    #             #self.XL = PlotParameter[2]
    #             #self.XH = PlotParameter[3]
    #             #self.YL = PlotParameter[4]
    #             #self.YH = PlotParameter[5]
    #         if (0 < len(self.VXCycleCount)):            
    #             self.PlotData.set_xdata(self.VXCycleCount)
    #             print('#######', self.VYFIC00)
    #             self.PlotData.set_ydata(self.VYFIC00)
    #             #self.Axes.set_xlim([self.XL, self.XH])
    #             #self.Axes.set_ylim([self.YL, self.YH])
    #             self.Canvas.draw()
    #             self.Canvas.flush_events()
    #             self.Parent.after(self.PeriodRefresh, self.RefreshValues, ticks)
    #         else:
    #             self.Parent.after(1000, self.RefreshValues, ticks)
    #     except:
    #         return
    #
#----------------------------------------------------------------------
#  Main
#----------------------------------------------------------------------
if ('__main__' == __name__):
    #
    print('*** FramePlot: begin')
    #
    #
    print('*** FramePlot: end')
    #
#    