//
#include "NtpDateTime.h"
//
CNtpDateTime::CNtpDateTime(void)
{
}

// Property
IPAddress CNtpDateTime::GetLocalIP(void)
{
    return WiFi.localIP();
}

// Handler
void CNtpDateTime::ConnectWifi(const char* ssid, const char* password)
{
  Term("Connecting to ");
  Term(ssid);
  WiFi.disconnect(true);
  WiFi.mode(WIFI_OFF);
  delay(200);
  WiFi.mode(WIFI_MODE_STA);
  Term(" : ");
  WiFi.begin(ssid, password);  
  while (WiFi.status() != WL_CONNECTED) 
  {
    delay(500);
    Term(".");
  }
  Message("");
  Term("Connected to IPAddress: ");
  Message(WiFi.localIP().toString().c_str());

}

void CNtpDateTime::DisconnectWifi(void)
{
    WiFi.disconnect(true);
}
void CNtpDateTime::SetWifiModeOff(void)
{
    WiFi.mode(WIFI_OFF);
}

void CNtpDateTime::Initialise(const char* ntpserver, 
                              long gmtoffset, int daylightoffset)
{
    configTime(gmtoffset, daylightoffset, ntpserver);
    this->GetDateTimeText();
}

const char* CNtpDateTime::GetDateTimeText(void)
{
    struct tm DateTime;
    if(getLocalTime(&DateTime))
    {
        sprintf(FBuffer, "%2.2u%2.2u%2.2u%2.2u%2.2u%2.2u", 
                DateTime.tm_year - 100, DateTime.tm_mon, DateTime.tm_mday, 
                DateTime.tm_hour, DateTime.tm_min, DateTime.tm_sec);
        return FBuffer;
    } 
    return "";
}

bool CNtpDateTime::GetDateTimeStructure(struct tm &datetime)
{    
    if (getLocalTime(&datetime))
    {
        datetime.tm_year -= 100;
        datetime.tm_mon += 1;
        // datetime.tm_hour += int((GMTOFFSET + DAYLIGHTOFFSET) / 3600);
        return true;
    }
    return false;
}