//
#ifndef SDCard_h
#define SDCard_h
//
//----------------------
//  Include
//----------------------
#include "Define.h"
//
#include <Arduino.h>
#include "FS.h"
#include "SD.h"
#include "SPI.h"
//
enum ECardType
{
    ctNone = 0,
    ctMMC = 1,
    ctSD = 2,
    ctSDHC = 3,
    ctUnknown = 4
};
//
const char* CardTypeText(ECardType cardtype);
//
class CSDCard
{
    private:
    int FPinSS;
    File FFile;
    //
    public:
    // Instance
    CSDCard(int pinss);    
    bool Initialise(void);
    // Property
    bool IsEndOfFile(void);
    ECardType GetCardType(void);
    uint64_t GetCardSizeMB(void);
    // WriteFile
    bool OpenWrite(const char* fileentry);
    bool OpenAppend(const char* fileentry);
    bool WriteCharacter(const char character);
    bool WriteText(const char* text);
    bool WriteLine(const char* line);
    bool CloseWrite(void);
    // ReadFile
    bool OpenRead(const char* fileentry);
    bool ReadCharacter(char &character);
    bool ReadText(char* text, unsigned &size);
    bool ReadLine(char* line);
    bool CloseRead(void);
    // File
    bool RenameFile(const char* entrysource, const char* entrytarget);
    bool RemoveFile(const char * entry);
    // Directory
    bool ListDirectory(const char* entry);
    bool CreateDirectory(const char* entry);
    bool RemoveDirectory(const char* entry);
};
//
#endif // SDCard_h