//
#include "Define.h"
//
#ifndef NtpDateTime_h
#define NtpDateTime_h
//
#include <WiFi.h>
#include "time.h"
//
//----------------------
//  Include
//----------------------
#include <Arduino.h>
//
class CNtpDateTime
{
    protected:
    TTerm FPTerm;
    TMessage FPMessage;
    TError FPError;
    char FBuffer[16];
    //
    public:
    // Instance
    CNtpDateTime(void);
    // Property
    IPAddress GetLocalIP(void);
    // Handler
    void DisconnectWifi(void);
    void SetWifiModeOff(void);
    void ConnectWifi(const char* ssid, const char* password);
    void Initialise(const char* ntpserver, long gmtoffset, 
                    int daylightoffset);
    const char* GetDateTimeText(void);
    bool GetDateTimeStructure(struct tm &datetime);
};
//
#endif // NtpDateTime_h
//