//
#include <Arduino.h>
//
//--------------------------------------------------------------
//  Define - Global
//--------------------------------------------------------------
#define UartPC Serial
//
const int PIN_LEDSYSTEM = 2;
const int SIZE_TXBUFFER = 48;
//
//--------------------------------------------------------------
//  Instance - Global
//--------------------------------------------------------------
double Time = 0.0; // [s]
double Voltage = 0.0; // [V]
double Period = 30.0; // [s]
double Amplitude = 1.0; // [V]
char TxBuffer[SIZE_TXBUFFER];
//
//--------------------------------------------------------------
//  Main - Setup
//--------------------------------------------------------------
void setup() 
{ // Uart
  UartPC.begin(115200);
  delay(333);
  // LedSystem
  pinMode(PIN_LEDSYSTEM, OUTPUT);
  digitalWrite(PIN_LEDSYSTEM, HIGH);
  // Setup
  UartPC.println("");
  UartPC.println("#***************************");
  UartPC.println("# Esp32RealTimeMeasurement *");
  UartPC.println("# Version  : 00V02         *");
  UartPC.println("# Hardware : Esp32         *");
  UartPC.println("# Date     : 211116        *");
  UartPC.println("# Time     : 1712          *");
  UartPC.println("# Author   : OMdevelop     *");
  UartPC.println("#***************************");
  UartPC.println("# - Simulation of time dependent");
  UartPC.println("#   measurement values");
  UartPC.println("# - rising amplitude");
  UartPC.println("");
  Time = 0.000;
}
//
//--------------------------------------------------------------
//  Main - Loop
//--------------------------------------------------------------
void loop() 
{
  digitalWrite(PIN_LEDSYSTEM, HIGH);
  delay(49);
  digitalWrite(PIN_LEDSYSTEM, LOW);
  delay(49);
  //
  double R = random(-1000, +1000) / 1000.0;
  double A = Amplitude * (0.9 + 0.2 * R);
  Voltage = A * sin(6.28 * Time / Period) + 0.01 * Time;
  sprintf(TxBuffer, "! %10.6f %10.6f", Time, Voltage);
  UartPC.println(TxBuffer);
  //  
  Time += 0.400;
  if (120.0 < Time)
  {
      Time = 0.000;
  }
}