#
#----------------------------------------------------------------------
#   CheckUart
#----------------------------------------------------------------------
#
# >>> pip install pyserial
#
import serial as SER
#
#----------------------------------------------------------------------
#   CUart
#----------------------------------------------------------------------
class CUart():
    #
    def __init__(self, identifier, portname):
        self.ID = identifier
        self.Serial = SER.Serial(portname, 
                                 baudrate=115200, 
                                 parity=SER.PARITY_NONE, \
                                 stopbits=SER.STOPBITS_ONE,
                                 bytesize=SER.EIGHTBITS,
                                 xonxoff=False,
                                 rtscts=False,
                                 dsrdtr=False,
                                 timeout=0.001)
    #
    def Close(self):
        self.Serial.close()
    #
    def ReadCharacter(self):
        B = self.Serial.read()
        if (b'' == B):
            return (0x00).decode('utf-8')
        return B.decode('utf-8')
    #
    def ReadLine(self):
        RxBreak = False
        RxLine = ''
        while not(RxBreak): 
            B = self.Serial.read()
            if (b'' == B):
                RxBreak = True # Empty RxLine!
            else: # debug print(B)
                if (b'\r' == B):
                    RxBreak = True
                else:
                    if (b'\n' == B):
                        RxBreak = True
                    else:
                        RxLine += B.decode('utf-8')
        return RxLine       
#
#----------------------------------------------------------------------
#   Main
#----------------------------------------------------------------------
if ('__main__' == __name__):
    #
    print('*** CheckUart: begin')
    #
    try:
        UartEsp32 = CUart('UC', 'COM21')
        LineCount = 0
        while (LineCount < 10):
            RxLine = UartEsp32.ReadLine()
            if (0 < len(RxLine)):
                LineCount += 1
                print('RxLine<<<' + RxLine + '>>>')
    #except:
    #    print('EEE')
    finally:
        UartEsp32.Close()
    #
    print('*** CheckUart: end')
    #
#


