#
#----------------------------------------------------------------------
#   Thread
#----------------------------------------------------------------------
import threading as THR
from time import sleep as Sleep
#
#----------------------------------------------------------------------
#   CThread
#----------------------------------------------------------------------
class CThread():
    #
    def __init__(self, id, onexecution):
        self.ID = id
        self.OnExecution = onexecution
        self.Thread = THR.Thread(target=self.OnExecution, args=(id, self))
        self.Aborted = False
    #
    def GetID(self):
        return self.ID
    #
    def IsBusy(self):        
        return not(self.Aborted)
    #
    def Start(self):
        self.Thread.start()
    #
    def Abort(self):
        self.Aborted = True
    #   
    def WaitForEnd(self):
        self.Thread.join()
#
#----------------------------------------------------------------------
#   Main
#----------------------------------------------------------------------
def CBOnThreadExecution(id, thread):
    while (thread.IsBusy()):
        print('...')
        Sleep(1.0)
#
if ('__main__' == __name__):
    #
    print('*** CheckThread: begin')
    #
    ThreadA = CThread('THA', CBOnThreadExecution)
    ThreadA.Start()
    #
    Sleep(5.0)
    #
    ThreadA.Abort()
    ThreadA.WaitForEnd()
    #
    print('*** CheckThread: end')
    #
#


