//
#include <Arduino.h>
//
const int PIN_PWM = PA6;
const int CHANNEL_PWM = 1;
const long unsigned FREQUENCY_PWM = 20000; // [Hz]
const long unsigned PWM_ZERO = 0;         // [%]
const long unsigned PWM_50PCT = 32767;    // [%]
const long unsigned PWM_100PCT = 65535;   // [%]
//
HardwareTimer TimerPwm(TIM3);
//
int PWM = 0;
//
void setup() 
{
    TimerPwm.setPWM(CHANNEL_PWM, PA6, FREQUENCY_PWM, PWM_ZERO); 
}
//
void loop() 
{
    TimerPwm.setCaptureCompare(CHANNEL_PWM, PWM, RESOLUTION_16B_COMPARE_FORMAT);
    PWM += 1;
    if (PWM_100PCT < PWM)
    {
        PWM = PWM_ZERO;
        TimerPwm.setCaptureCompare(CHANNEL_PWM, PWM_ZERO, RESOLUTION_16B_COMPARE_FORMAT);
        delay(1000);
    }
    else
    if (PWM_50PCT == PWM)
    {
        TimerPwm.setCaptureCompare(CHANNEL_PWM, PWM_50PCT, RESOLUTION_16B_COMPARE_FORMAT);
        delay(1000);
    }
    else
    {
        delayMicroseconds(100);
    }
}
//
