//
#include <Arduino.h>
//
const int PIN_PWMA = PB6; 
const int PIN_PWMB = PB7; 
const int PIN_PWMC = PB8;
const int PIN_PWMD = PB9;
const int CHANNEL_PWMA = 1;
const int CHANNEL_PWMB = 2;
const int CHANNEL_PWMC = 3;
const int CHANNEL_PWMD = 4;
const long unsigned FREQUENCY_PWM = 20000; // [Hz]
const long unsigned PWM_ZERO = 0;          // []
const long unsigned PWM_50PCT = 32767;     // []
const long unsigned PWM_100PCT = 65535;    // []
//
HardwareTimer TimerPwm(TIM4);
//
int PWM12 = PWM_ZERO;
int PWM34 = PWM_50PCT;
//
void setup() 
{
    TimerPwm.setPWM(CHANNEL_PWMA, PIN_PWMA, FREQUENCY_PWM, PWM_ZERO); 
    TimerPwm.setPWM(CHANNEL_PWMB, PIN_PWMB, FREQUENCY_PWM, PWM_ZERO); 
    TimerPwm.setPWM(CHANNEL_PWMC, PIN_PWMC, FREQUENCY_PWM, PWM_ZERO); 
    TimerPwm.setPWM(CHANNEL_PWMD, PIN_PWMD, FREQUENCY_PWM, PWM_ZERO); 
}
//
void loop() 
{
    TimerPwm.setCaptureCompare(CHANNEL_PWMA, PWM12, RESOLUTION_16B_COMPARE_FORMAT);
    TimerPwm.setCaptureCompare(CHANNEL_PWMB, PWM_100PCT - PWM12, RESOLUTION_16B_COMPARE_FORMAT);
    TimerPwm.setCaptureCompare(CHANNEL_PWMC, PWM34, RESOLUTION_16B_COMPARE_FORMAT);
    TimerPwm.setCaptureCompare(CHANNEL_PWMD, PWM_100PCT - PWM34, RESOLUTION_16B_COMPARE_FORMAT);
    PWM12 += 1;
    PWM34 += 1;
    if (PWM_100PCT < PWM12)
    {
        PWM12 = PWM_ZERO;
        delay(1000);
    }
    if (PWM_100PCT < PWM34)
    {
        PWM34 = PWM_ZERO;
        delay(1000);
    }
}
//
